/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.AbstractMethodProblem;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.DependencyConflict;
import com.google.cloud.tools.opensource.classpath.LinkageProblemCause;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.aether.artifact.Artifact;

public abstract class LinkageProblem {
    private final Symbol symbol;
    private final ClassFile sourceClass;
    private final String symbolProblemMessage;
    private LinkageProblemCause cause;
    private ClassFile targetClass;

    LinkageProblem(String symbolProblemMessage, ClassFile sourceClass, Symbol symbol, @Nullable ClassFile targetClass) {
        this.symbolProblemMessage = (String)Preconditions.checkNotNull((Object)symbolProblemMessage);
        Preconditions.checkNotNull((Object)symbol);
        this.symbol = symbol instanceof SuperClassSymbol ? new ClassSymbol(symbol.getClassBinaryName()) : symbol;
        this.sourceClass = (ClassFile)Preconditions.checkNotNull((Object)sourceClass);
        this.targetClass = targetClass;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public ClassFile getSourceClass() {
        return this.sourceClass;
    }

    @Nullable
    public ClassFile getTargetClass() {
        return this.targetClass;
    }

    void setCause(LinkageProblemCause cause) {
        this.cause = (LinkageProblemCause)Preconditions.checkNotNull((Object)cause);
    }

    LinkageProblemCause getCause() {
        return this.cause;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LinkageProblem that = (LinkageProblem)other;
        return this.symbol.equals(that.symbol) && Objects.equals(this.sourceClass, that.sourceClass) && Objects.equals(this.targetClass, that.targetClass);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.sourceClass, this.targetClass);
    }

    public String toString() {
        return this.formatSymbolProblem() + " referenced by " + this.sourceClass;
    }

    public String formatSymbolProblem() {
        String result = this.symbol + " " + this.symbolProblemMessage;
        if (this.targetClass != null) {
            String jarInfo = "(" + this.getTargetClass().getClassPathEntry() + ") ";
            result = jarInfo + result;
        }
        return result;
    }

    protected String formatSymbolProblemWithReferenceCount(int referenceCount) {
        return String.format("%s;\n  referenced by %d class file%s\n", this.formatSymbolProblem(), referenceCount, referenceCount > 1 ? "s" : "");
    }

    public static ImmutableMap<String, ImmutableSet<String>> groupBySymbolProblem(Iterable<LinkageProblem> linkageProblems) {
        ImmutableListMultimap groupedMultimap = Multimaps.index(linkageProblems, problem -> problem.formatSymbolProblem());
        ListMultimap symbolProblemToSourceClasses = Multimaps.transformValues((ListMultimap)groupedMultimap, problem -> problem.getSourceClass().getBinaryName());
        Map valueTransformed = Maps.transformValues((Map)symbolProblemToSourceClasses.asMap(), ImmutableSet::copyOf);
        return ImmutableMap.copyOf((Map)valueTransformed);
    }

    public static String formatLinkageProblems(Set<LinkageProblem> linkageProblems, @Nullable ClassPathResult classPathResult) {
        StringBuilder output = new StringBuilder();
        ImmutableSet.Builder abstractMethodProblems = ImmutableSet.builder();
        ImmutableSet.Builder problemsToGroupBySymbols = ImmutableSet.builder();
        for (LinkageProblem linkageProblem : linkageProblems) {
            if (linkageProblem instanceof AbstractMethodProblem) {
                abstractMethodProblems.add((Object)((AbstractMethodProblem)linkageProblem));
                continue;
            }
            problemsToGroupBySymbols.add((Object)linkageProblem);
        }
        ImmutableListMultimap groupBySymbols = Multimaps.index((Iterable)problemsToGroupBySymbols.build(), problem -> problem.getSymbol());
        groupBySymbols.asMap().forEach((symbol, problems) -> {
            LinkageProblem firstProblem = (LinkageProblem)Iterables.getFirst((Iterable)problems, null);
            int referenceCount = problems.size();
            output.append(firstProblem.formatSymbolProblemWithReferenceCount(referenceCount));
            ImmutableSet.Builder causesBuilder = ImmutableSet.builder();
            problems.forEach(problem -> {
                ClassFile sourceClassFile = problem.getSourceClass();
                output.append("    " + sourceClassFile.getBinaryName());
                output.append(" (" + sourceClassFile.getClassPathEntry() + ")\n");
                LinkageProblemCause cause = problem.getCause();
                if (cause != null) {
                    causesBuilder.add((Object)cause);
                }
            });
            ImmutableSet causes = causesBuilder.build();
            if (!causes.isEmpty()) {
                output.append("  Cause:\n");
                for (LinkageProblemCause cause : causes) {
                    String causeWithIndent = cause.toString().replaceAll("\n", "\n    ");
                    output.append("    " + causeWithIndent + "\n");
                }
            }
        });
        for (AbstractMethodProblem abstractMethodProblem : abstractMethodProblems.build()) {
            output.append(abstractMethodProblem + "\n");
            output.append("  Cause:\n");
            LinkageProblemCause cause = abstractMethodProblem.getCause();
            String causeWithIndent = cause.toString().replaceAll("\n", "\n    ");
            output.append("    " + causeWithIndent + "\n");
        }
        if (classPathResult != null) {
            String dependencyPaths = LinkageProblem.dependencyPathsOfProblematicJars(classPathResult, linkageProblems);
            output.append(dependencyPaths);
        }
        return output.toString();
    }

    private static String dependencyPathsOfProblematicJars(ClassPathResult classPathResult, Set<LinkageProblem> linkageProblems) {
        ImmutableSet.Builder problematicJars = ImmutableSet.builder();
        for (LinkageProblem problem : linkageProblems) {
            if (problem.getTargetClass() != null) {
                problematicJars.add((Object)problem.getTargetClass().getClassPathEntry());
            }
            ClassFile sourceClass = problem.getSourceClass();
            problematicJars.add((Object)sourceClass.getClassPathEntry());
        }
        return "Problematic artifacts in the dependency tree:\n" + classPathResult.formatDependencyPaths((Iterable<ClassPathEntry>)problematicJars.build());
    }

    String describe(DependencyConflict conflict) {
        DependencyPath pathToSelectedArtifact = conflict.getPathToSelectedArtifact();
        Artifact selected = pathToSelectedArtifact.getLeaf();
        String selectedCoordinates = Artifacts.toCoordinates(selected);
        DependencyPath pathToArtifactThruSource = conflict.getPathToArtifactThruSource();
        Artifact unselected = pathToArtifactThruSource.getLeaf();
        String unselectedCoordinates = Artifacts.toCoordinates(unselected);
        return "Dependency conflict: " + selectedCoordinates + " does not define " + this.getSymbol() + " but " + unselectedCoordinates + " defines it.\n  selected: " + pathToSelectedArtifact + "\n  unselected: " + pathToArtifactThruSource;
    }
}

