/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.DependencyConflict;
import com.google.cloud.tools.opensource.classpath.ExcludedDependency;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.MissingDependency;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.cloud.tools.opensource.classpath.UnknownCause;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.aether.artifact.Artifact;

public final class LinkageProblemCauseAnnotator {
    private LinkageProblemCauseAnnotator() {
    }

    public static void annotate(ClassPathBuilder classPathBuilder, ClassPathResult rootResult, Iterable<LinkageProblem> linkageProblems) throws IOException {
        Preconditions.checkNotNull((Object)classPathBuilder);
        Preconditions.checkNotNull((Object)rootResult);
        Preconditions.checkNotNull(linkageProblems);
        HashMap<Artifact, ClassPathResult> cache = new HashMap<Artifact, ClassPathResult>();
        for (LinkageProblem linkageProblem : linkageProblems) {
            Symbol symbol;
            ClassPathEntry entryInSubtree;
            ClassFile sourceClass = linkageProblem.getSourceClass();
            ClassPathEntry sourceEntry = sourceClass.getClassPathEntry();
            Artifact sourceArtifact = sourceEntry.getArtifact();
            ClassPathResult subtreeResult = (ClassPathResult)cache.get(sourceArtifact);
            if (subtreeResult == null) {
                subtreeResult = classPathBuilder.resolveWithMaven(sourceArtifact);
                cache.put(sourceArtifact, subtreeResult);
            }
            if ((entryInSubtree = subtreeResult.findEntryBySymbol(symbol = linkageProblem.getSymbol())) == null) {
                linkageProblem.setCause(UnknownCause.getInstance());
                continue;
            }
            Artifact artifactInSubtree = entryInSubtree.getArtifact();
            DependencyPath pathToSourceEntry = (DependencyPath)rootResult.getDependencyPaths(sourceEntry).get(0);
            DependencyPath pathFromSourceEntryToUnselectedEntry = (DependencyPath)subtreeResult.getDependencyPaths(entryInSubtree).get(0);
            DependencyPath pathToUnselectedEntry = pathToSourceEntry.concat(pathFromSourceEntryToUnselectedEntry);
            ClassPathEntry selectedEntry = rootResult.findEntryById(artifactInSubtree.getGroupId(), artifactInSubtree.getArtifactId());
            if (selectedEntry != null) {
                Artifact selectedArtifact = selectedEntry.getArtifact();
                if (!selectedArtifact.getVersion().equals(artifactInSubtree.getVersion())) {
                    linkageProblem.setCause(new DependencyConflict(linkageProblem, (DependencyPath)rootResult.getDependencyPaths(selectedEntry).get(0), pathToUnselectedEntry));
                    continue;
                }
                linkageProblem.setCause(UnknownCause.getInstance());
                continue;
            }
            Artifact excludingArtifact = pathToSourceEntry.findExclusion(artifactInSubtree.getGroupId(), artifactInSubtree.getArtifactId());
            if (excludingArtifact != null) {
                linkageProblem.setCause(new ExcludedDependency(pathToUnselectedEntry, excludingArtifact));
                continue;
            }
            linkageProblem.setCause(new MissingDependency(pathToUnselectedEntry));
        }
    }
}

