/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;

class MavenDependencyMediation {
    private List<Artifact> artifacts = new ArrayList<Artifact>();

    MavenDependencyMediation() {
    }

    boolean selects(Artifact artifact) {
        return this.artifacts.contains(artifact);
    }

    void put(DependencyPath dependencyPath) {
        Artifact artifact = dependencyPath.getLeaf();
        File file = artifact.getFile();
        if (file == null) {
            return;
        }
        Path jarAbsolutePath = file.toPath().toAbsolutePath();
        if (!jarAbsolutePath.toString().endsWith(".jar")) {
            return;
        }
        this.put(artifact);
    }

    private void put(Artifact artifact) {
        if (this.artifacts.stream().map(Artifacts::makeKey).anyMatch(key -> Artifacts.makeKey(artifact).equals(key))) {
            return;
        }
        this.artifacts.add(artifact);
    }
}

