/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Utility;

class ReturnTypeChangedProblem
extends LinkageProblem {
    private String actualType;

    ReturnTypeChangedProblem(ClassFile sourceClass, @Nullable ClassFile targetClass, MethodSymbol expectedMethodSymbol, String actualType) {
        super("is expected to return " + Utility.methodSignatureReturnType((String)expectedMethodSymbol.getDescriptor()) + " but instead returns " + actualType, sourceClass, expectedMethodSymbol, targetClass);
        this.actualType = actualType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.actualType);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(this.actualType, ((ReturnTypeChangedProblem)other).actualType);
    }
}

