/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class ArtifactProblem {
    protected final Artifact artifact;
    protected final ImmutableList<DependencyNode> dependencyPath;

    protected ArtifactProblem(Artifact artifact, List<DependencyNode> dependencyPath) {
        this.artifact = (Artifact)Preconditions.checkNotNull((Object)artifact);
        this.dependencyPath = ImmutableList.copyOf(dependencyPath);
    }

    protected String getPath() {
        return Joiner.on((String)" > ").join(this.dependencyPath);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public static String formatProblems(Iterable<ArtifactProblem> problems) {
        ImmutableListMultimap artifactToProblems = Multimaps.index(problems, ArtifactProblem::getArtifact);
        StringBuilder output = new StringBuilder();
        for (Artifact artifact : artifactToProblems.keySet()) {
            ImmutableList artifactProblems = artifactToProblems.get((Object)artifact);
            int otherCount = artifactProblems.size() - 1;
            Verify.verify((otherCount >= 0 ? 1 : 0) != 0, (String)"artifactToProblems should have at least one value for one key", (Object[])new Object[0]);
            ArtifactProblem firstProblem = (ArtifactProblem)Iterables.getFirst((Iterable)artifactProblems, null);
            output.append(firstProblem);
            if (otherCount == 1) {
                output.append(" and a problem on the same artifact.");
            } else if (otherCount > 1) {
                output.append(" and " + otherCount + " problems on the same artifact.");
            }
            output.append("\n");
        }
        return output.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ArtifactProblem otherProblem = (ArtifactProblem)other;
        return Objects.equals(this.artifact, otherProblem.artifact) && ArtifactProblem.equalsOnDependencies(this.dependencyPath, otherProblem.dependencyPath);
    }

    private static boolean equalsOnDependencies(List<DependencyNode> listA, List<DependencyNode> listB) {
        int size = listA.size();
        if (listB.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Dependency dependencyB;
            DependencyNode nodeA = listA.get(i);
            DependencyNode nodeB = listB.get(i);
            Dependency dependencyA = nodeA.getDependency();
            if (Objects.equals(dependencyA, dependencyB = nodeB.getDependency())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ImmutableList dependencyList = (ImmutableList)this.dependencyPath.stream().map(DependencyNode::getDependency).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        return Objects.hash(this.artifact, dependencyList);
    }
}

