/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public final class Bom {
    private static final ImmutableSet<String> BOM_SKIP_ARTIFACT_IDS = ImmutableSet.of((Object)"google-cloud-logging-logback", (Object)"google-cloud-contrib");
    private final ImmutableList<Artifact> artifacts;
    private final String coordinates;

    @VisibleForTesting
    public Bom(String coordinates, ImmutableList<Artifact> artifacts) {
        this.coordinates = (String)Preconditions.checkNotNull((Object)coordinates);
        if (artifacts == null) {
            artifacts = ImmutableList.of();
        }
        this.artifacts = artifacts;
    }

    public ImmutableList<Artifact> getManagedDependencies() {
        return this.artifacts;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public static Bom readBom(Path pomFile) throws MavenRepositoryException {
        RepositorySystem system = RepositoryUtility.newRepositorySystem();
        DefaultRepositorySystemSession session = RepositoryUtility.newSession(system);
        MavenProject mavenProject = RepositoryUtility.createMavenProject(pomFile, (RepositorySystemSession)session);
        String coordinates = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion();
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();
        List dependencies = dependencyManagement.getDependencies();
        ArtifactTypeRegistry registry = session.getArtifactTypeRegistry();
        ImmutableList artifacts = (ImmutableList)dependencies.stream().map(dependency -> RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)registry)).map(org.eclipse.aether.graph.Dependency::getArtifact).filter(artifact -> !Bom.shouldSkipBomMember(artifact)).collect(ImmutableList.toImmutableList());
        Bom bom = new Bom(coordinates, (ImmutableList<Artifact>)artifacts);
        return bom;
    }

    public static Bom readBom(String coordinates, List<String> mavenRepositoryUrls) throws ArtifactDescriptorException {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        RepositorySystem system = RepositoryUtility.newRepositorySystem();
        DefaultRepositorySystemSession session = RepositoryUtility.newSession(system);
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
        for (String repositoryUrl : mavenRepositoryUrls) {
            request.addRepository(RepositoryUtility.mavenRepositoryFromUrl(repositoryUrl));
        }
        request.setArtifact((Artifact)artifact);
        ArtifactDescriptorResult resolved = system.readArtifactDescriptor((RepositorySystemSession)session, request);
        List exceptions = resolved.getExceptions();
        if (!exceptions.isEmpty()) {
            throw new ArtifactDescriptorException(resolved, ((Exception)exceptions.get(0)).getMessage());
        }
        ArrayList<Artifact> managedDependencies = new ArrayList<Artifact>();
        for (org.eclipse.aether.graph.Dependency dependency : resolved.getManagedDependencies()) {
            Artifact managed = dependency.getArtifact();
            if (Bom.shouldSkipBomMember(managed) || managedDependencies.contains(managed)) continue;
            managedDependencies.add(managed);
        }
        Bom bom = new Bom(coordinates, (ImmutableList<Artifact>)ImmutableList.copyOf(managedDependencies));
        return bom;
    }

    public static Bom readBom(String coordinates) throws ArtifactDescriptorException {
        return Bom.readBom(coordinates, (List<String>)ImmutableList.of((Object)RepositoryUtility.CENTRAL.getUrl()));
    }

    public static boolean shouldSkipBomMember(Artifact artifact) {
        if ("testlib".equals(artifact.getClassifier())) {
            return true;
        }
        String type = artifact.getProperty("type", "jar");
        if ("test-jar".equals(type)) {
            return true;
        }
        return BOM_SKIP_ARTIFACT_IDS.contains((Object)artifact.getArtifactId());
    }
}

