/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.OsProperties;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

public final class DependencyGraphBuilder {
    private static final RepositorySystem system = RepositoryUtility.newRepositorySystem();
    private final ImmutableList<RemoteRepository> repositories;
    private Path localRepository;

    public DependencyGraphBuilder() {
        this((Iterable<String>)ImmutableList.of((Object)RepositoryUtility.CENTRAL.getUrl()));
    }

    public DependencyGraphBuilder(Iterable<String> mavenRepositoryUrls) {
        ImmutableList.Builder repositoryListBuilder = ImmutableList.builder();
        for (String mavenRepositoryUrl : mavenRepositoryUrls) {
            RemoteRepository repository = RepositoryUtility.mavenRepositoryFromUrl(mavenRepositoryUrl);
            repositoryListBuilder.add((Object)repository);
        }
        this.repositories = repositoryListBuilder.build();
    }

    @VisibleForTesting
    void setLocalRepository(Path localRepository) {
        this.localRepository = localRepository;
    }

    private DependencyNode resolveCompileTimeDependencies(List<DependencyNode> dependencyNodes, DefaultRepositorySystemSession session) throws DependencyResolutionException {
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        for (DependencyNode dependencyNode : dependencyNodes) {
            Dependency dependency = dependencyNode.getDependency();
            if (dependency == null) {
                dependenciesBuilder.add((Object)new Dependency(dependencyNode.getArtifact(), "compile"));
                continue;
            }
            dependenciesBuilder.add((Object)dependency.setScope("compile"));
        }
        ImmutableList dependencyList = dependenciesBuilder.build();
        if (this.localRepository != null) {
            LocalRepository local = new LocalRepository(this.localRepository.toAbsolutePath().toString());
            session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, local));
        }
        CollectRequest collectRequest = new CollectRequest();
        if (dependencyList.size() == 1) {
            collectRequest.setRoot((Dependency)dependencyList.get(0));
        } else {
            collectRequest.setDependencies((List)dependencyList);
        }
        for (RemoteRepository repository : this.repositories) {
            collectRequest.addRepository(repository);
        }
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        DependencyResult dependencyResult = system.resolveDependencies((RepositorySystemSession)session, dependencyRequest);
        return dependencyResult.getRoot();
    }

    public DependencyGraph buildFullDependencyGraph(List<Artifact> artifacts) {
        ImmutableList dependencyNodes = (ImmutableList)artifacts.stream().map(DefaultDependencyNode::new).collect(ImmutableList.toImmutableList());
        DefaultRepositorySystemSession session = RepositoryUtility.newSessionForFullDependency(system);
        return this.buildDependencyGraph((List<DependencyNode>)dependencyNodes, session);
    }

    public DependencyGraph buildVerboseDependencyGraph(List<Artifact> artifacts) {
        ImmutableList dependencyNodes = (ImmutableList)artifacts.stream().map(DefaultDependencyNode::new).collect(ImmutableList.toImmutableList());
        DefaultRepositorySystemSession session = RepositoryUtility.newSessionForVerboseListDependency(system);
        return this.buildDependencyGraph((List<DependencyNode>)dependencyNodes, session);
    }

    public DependencyGraph buildVerboseDependencyGraph(Artifact artifact) {
        Dependency dependency = new Dependency(artifact, "compile");
        return this.buildVerboseDependencyGraph(dependency);
    }

    DependencyGraph buildVerboseDependencyGraph(Dependency dependency) {
        DefaultRepositorySystemSession session = RepositoryUtility.newSessionForVerboseDependency(system);
        ImmutableList roots = ImmutableList.of((Object)new DefaultDependencyNode(dependency));
        return this.buildDependencyGraph((List<DependencyNode>)roots, session);
    }

    public DependencyGraph buildMavenDependencyGraph(Dependency dependency) {
        ImmutableList roots = ImmutableList.of((Object)new DefaultDependencyNode(dependency));
        return this.buildDependencyGraph((List<DependencyNode>)roots, RepositoryUtility.newSessionForMaven(system));
    }

    private DependencyGraph buildDependencyGraph(List<DependencyNode> dependencyNodes, DefaultRepositorySystemSession session) {
        try {
            DependencyNode node = this.resolveCompileTimeDependencies(dependencyNodes, session);
            return DependencyGraph.from(node);
        }
        catch (DependencyResolutionException ex) {
            DependencyResult result = ex.getResult();
            DependencyGraph graph = DependencyGraph.from(result.getRoot());
            for (ArtifactResult artifactResult : result.getArtifactResults()) {
                Artifact resolvedArtifact = artifactResult.getArtifact();
                if (resolvedArtifact != null) continue;
                Artifact requestedArtifact = artifactResult.getRequest().getArtifact();
                graph.addUnresolvableArtifactProblem(requestedArtifact);
            }
            return graph;
        }
    }

    static {
        OsProperties.detectOsProperties().forEach(System::setProperty);
    }
}

