/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.ArtifactProblem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.aether.graph.DependencyNode;

public final class InvalidClassFileProblem
extends ArtifactProblem {
    private final ImmutableList<String> classFileNames;

    InvalidClassFileProblem(List<DependencyNode> dependencyPath, List<String> classFileNames) {
        super(dependencyPath.get(dependencyPath.size() - 1).getArtifact(), dependencyPath);
        Preconditions.checkArgument((!classFileNames.isEmpty() ? 1 : 0) != 0, (Object)"ClassFileNames cannot be empty");
        this.classFileNames = ImmutableList.copyOf(classFileNames);
    }

    public String toString() {
        int classFileCount = this.classFileNames.size();
        String classFileDescription = classFileCount == 1 ? "an invalid class file " + (String)this.classFileNames.get(0) + "." : classFileCount + " invalid class files (example: " + (String)this.classFileNames.get(0) + ").";
        return this.artifact + " contains " + classFileDescription + " Dependency path: " + this.getPath();
    }
}

