/*
 * Decompiled with CFR 0.152.
 */
package com.google.mu.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.TableResult;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.annotations.Immutable;
import com.google.mu.annotations.TemplateFormatMethod;
import com.google.mu.annotations.TemplateString;
import com.google.mu.util.StringFormat;
import com.google.mu.util.stream.BiStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Immutable
public final class ParameterizedQuery {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSZZ");
    private final String query;
    private final Map<String, QueryParameterValue> parameters;
    private final Map<String, Object> originalValues;
    public static ParameterizedQuery EMPTY = ParameterizedQuery.of("");

    private ParameterizedQuery(String query) {
        this.query = Objects.requireNonNull(query);
        this.parameters = Collections.emptyMap();
        this.originalValues = Collections.emptyMap();
    }

    private ParameterizedQuery(String query, Map<String, QueryParameterValue> parameters, Map<String, Object> originalValues) {
        this.query = Objects.requireNonNull(query);
        this.parameters = Collections.unmodifiableMap(new LinkedHashMap<String, QueryParameterValue>(parameters));
        this.originalValues = Collections.unmodifiableMap(new HashMap<String, Object>(originalValues));
    }

    @TemplateFormatMethod
    public static ParameterizedQuery of(@CompileTimeConstant @TemplateString String query) {
        return new ParameterizedQuery(query);
    }

    @TemplateFormatMethod
    public static ParameterizedQuery of(@CompileTimeConstant @TemplateString String query, Object ... args) {
        return (ParameterizedQuery)ParameterizedQuery.template(query).with(args);
    }

    @TemplateFormatMethod
    public static ParameterizedQuery optionally(@CompileTimeConstant @TemplateString String query, Optional<?> arg) {
        return arg.map(v -> ParameterizedQuery.of(query, v)).orElse(EMPTY);
    }

    public static StringFormat.Template<ParameterizedQuery> template(@CompileTimeConstant String template) {
        return StringFormat.template((String)template, (fragments, placeholders) -> {
            Iterator it = fragments.iterator();
            return ((Builder)placeholders.collect((Object)new Builder(), (builder, placeholder, value) -> {
                builder.append((String)it.next());
                if (value == null) {
                    builder.append("NULL");
                } else if (value instanceof ParameterizedQuery) {
                    builder.addSubQuery((ParameterizedQuery)value);
                } else {
                    String paramName = placeholder.skip(1, 1).toString().trim();
                    builder.append("@" + paramName);
                    builder.addParameter(paramName, value);
                }
            })).append((String)it.next()).build();
        });
    }

    public static Stream<ParameterizedQuery> enumConstants(Class<? extends Enum<?>> enumClass) {
        return Arrays.stream(enumClass.getEnumConstants()).map(e -> new ParameterizedQuery(e.name()));
    }

    public static Collector<ParameterizedQuery, ?, ParameterizedQuery> and() {
        return Collectors.collectingAndThen(ParameterizedQuery.nonEmptyQueries(Collectors.mapping(ParameterizedQuery::parenthesized, ParameterizedQuery.joining(" AND "))), query -> query.query.isEmpty() ? ParameterizedQuery.of("TRUE") : query);
    }

    public static Collector<ParameterizedQuery, ?, ParameterizedQuery> or() {
        return Collectors.collectingAndThen(ParameterizedQuery.nonEmptyQueries(Collectors.mapping(ParameterizedQuery::parenthesized, ParameterizedQuery.joining(" OR "))), query -> query.query.isEmpty() ? ParameterizedQuery.of("FALSE") : query);
    }

    public static Collector<ParameterizedQuery, ?, ParameterizedQuery> joining(@CompileTimeConstant String delimiter) {
        return Collector.of(() -> new Builder(), (A b, T q) -> b.appendDelimiter(delimiter).addSubQuery((ParameterizedQuery)q), (b1, b2) -> b1.appendDelimiter(delimiter).addSubQuery(b2.build()), Builder::build, new Collector.Characteristics[0]);
    }

    public TableResult run(BigQuery.JobOption ... options) throws JobException, InterruptedException {
        return ((BigQuery)BigQueryOptions.getDefaultInstance().getService()).query(this.jobConfiguration(), options);
    }

    public QueryJobConfiguration jobConfiguration() {
        return ((QueryJobConfiguration.Builder)BiStream.from(this.parameters).collect((Object)QueryJobConfiguration.newBuilder((String)this.query), QueryJobConfiguration.Builder::addNamedParameter)).build();
    }

    public int hashCode() {
        return Objects.hash(this.query, this.parameters);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterizedQuery) {
            ParameterizedQuery that = (ParameterizedQuery)obj;
            return this.query.equals(that.query) && this.parameters.equals(that.parameters);
        }
        return false;
    }

    public String toString() {
        return this.query;
    }

    private ParameterizedQuery parenthesized() {
        return new ParameterizedQuery("(" + this.query + ")");
    }

    private static <R> Collector<ParameterizedQuery, ?, R> nonEmptyQueries(Collector<ParameterizedQuery, ?, R> downstream) {
        return ParameterizedQuery.filtering(q -> !q.query.isEmpty(), downstream);
    }

    private static <T, A, R> Collector<T, A, R> filtering(Predicate<? super T> filter, Collector<? super T, A, R> collector) {
        BiConsumer accumulator = collector.accumulator();
        return Collector.of(collector.supplier(), (A a, T input) -> {
            if (filter.test(input)) {
                accumulator.accept(a, input);
            }
        }, collector.combiner(), collector.finisher(), collector.characteristics().toArray(new Collector.Characteristics[0]));
    }

    private static final class Builder {
        private final StringBuilder queryText = new StringBuilder();
        private final LinkedHashMap<String, QueryParameterValue> parameters = new LinkedHashMap();
        private final Map<String, Object> originalValues = new HashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        Builder append(String snippet) {
            this.queryText.append(snippet);
            return this;
        }

        @CanIgnoreReturnValue
        Builder appendDelimiter(String delim) {
            if (this.queryText.length() > 0) {
                this.queryText.append(delim);
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder addSubQuery(ParameterizedQuery subQuery) {
            this.queryText.append(subQuery.query);
            BiStream.from((Map)subQuery.parameters).forEachOrdered((name, value) -> this.internalAddParameter((String)name, subQuery.originalValues.get(name), (QueryParameterValue)value));
            return this;
        }

        @CanIgnoreReturnValue
        Builder addParameter(String name, Object originalValue) {
            return this.internalAddParameter(name, originalValue, Builder.toQueryParameter(originalValue));
        }

        private Builder internalAddParameter(String name, Object originalValue, QueryParameterValue value) {
            Object oldValue = this.originalValues.put(name, originalValue);
            if (oldValue != null) {
                if (oldValue.equals(originalValue)) {
                    return this;
                }
                throw new IllegalArgumentException("Duplicate placeholder name: " + name);
            }
            this.parameters.put(name, value);
            return this;
        }

        ParameterizedQuery build() {
            return new ParameterizedQuery(this.queryText.toString(), this.parameters, this.originalValues);
        }

        private static QueryParameterValue toQueryParameter(Object value) {
            if (value instanceof CharSequence) {
                return QueryParameterValue.string((String)value.toString());
            }
            if (value instanceof Instant) {
                Instant time = (Instant)value;
                return QueryParameterValue.timestamp((String)time.atZone(ZoneId.of("UTC")).format(TIMESTAMP_FORMATTER));
            }
            if (value instanceof LocalDate) {
                return QueryParameterValue.date((String)((LocalDate)value).toString());
            }
            if (value instanceof Boolean) {
                return QueryParameterValue.bool((Boolean)((Boolean)value));
            }
            if (value instanceof Integer) {
                return QueryParameterValue.int64((Integer)((Integer)value));
            }
            if (value instanceof Long) {
                return QueryParameterValue.int64((Long)((Long)value));
            }
            if (value instanceof Double) {
                return QueryParameterValue.float64((Double)((Double)value));
            }
            if (value instanceof Float) {
                return QueryParameterValue.float64((Float)((Float)value));
            }
            if (value instanceof BigDecimal) {
                return QueryParameterValue.bigNumeric((BigDecimal)((BigDecimal)value));
            }
            if (value instanceof byte[]) {
                return QueryParameterValue.bytes((byte[])((byte[])value));
            }
            if (value instanceof QueryParameterValue) {
                return (QueryParameterValue)value;
            }
            if (value instanceof Enum) {
                return QueryParameterValue.string((String)((Enum)value).name());
            }
            if (value.getClass().isArray()) {
                Class<?> componentType = value.getClass().getComponentType();
                return QueryParameterValue.array((Object[])((Object[])value), componentType);
            }
            throw new IllegalArgumentException("Unsupported parameter type: " + value.getClass().getName() + ". Consider manually converting it to QueryParameterValue.");
        }
    }
}

