/*
 * Decompiled with CFR 0.152.
 */
package com.google.mu.protobuf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.primitives.ImmutableDoubleArray;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.mu.protobuf.util.MoreStructs;
import com.google.mu.protobuf.util.MoreValues;
import com.google.mu.protobuf.util.StructBuilder;
import com.google.mu.util.stream.BiCollector;
import com.google.mu.util.stream.BiStream;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@CheckReturnValue
public class Structor {
    public final Struct struct(CharSequence name, @Nullable Object value) {
        return Struct.newBuilder().putFields(name.toString(), this.convertNonNull(value)).build();
    }

    public final Struct struct(CharSequence k1, @Nullable Object v1, CharSequence k2, @Nullable Object v2) {
        return new StructBuilder().add(k1.toString(), this.convertNonNull(v1)).add(k2.toString(), this.convertNonNull(v2)).build();
    }

    public final Struct struct(CharSequence k1, @Nullable Object v1, CharSequence k2, @Nullable Object v2, CharSequence k3, @Nullable Object v3) {
        return new StructBuilder().add(k1.toString(), this.convertNonNull(v1)).add(k2.toString(), this.convertNonNull(v2)).add(k3.toString(), this.convertNonNull(v3)).build();
    }

    public final Struct struct(CharSequence k1, @Nullable Object v1, CharSequence k2, @Nullable Object v2, CharSequence k3, @Nullable Object v3, CharSequence k4, @Nullable Object v4) {
        return new StructBuilder().add(k1.toString(), this.convertNonNull(v1)).add(k2.toString(), this.convertNonNull(v2)).add(k3.toString(), this.convertNonNull(v3)).add(k4.toString(), this.convertNonNull(v4)).build();
    }

    public final Struct struct(CharSequence k1, @Nullable Object v1, CharSequence k2, @Nullable Object v2, CharSequence k3, @Nullable Object v3, CharSequence k4, @Nullable Object v4, CharSequence k5, @Nullable Object v5) {
        return new StructBuilder().add(k1.toString(), this.convertNonNull(v1)).add(k2.toString(), this.convertNonNull(v2)).add(k3.toString(), this.convertNonNull(v3)).add(k4.toString(), this.convertNonNull(v4)).add(k5.toString(), this.convertNonNull(v5)).build();
    }

    public final Struct struct(CharSequence k1, @Nullable Object v1, CharSequence k2, @Nullable Object v2, CharSequence k3, @Nullable Object v3, CharSequence k4, @Nullable Object v4, CharSequence k5, @Nullable Object v5, CharSequence k6, @Nullable Object v6) {
        return new StructBuilder().add(k1.toString(), this.convertNonNull(v1)).add(k2.toString(), this.convertNonNull(v2)).add(k3.toString(), this.convertNonNull(v3)).add(k4.toString(), this.convertNonNull(v4)).add(k5.toString(), this.convertNonNull(v5)).add(k6.toString(), this.convertNonNull(v6)).build();
    }

    public final Struct struct(Map<String, ?> map) {
        return ((Struct.Builder)BiStream.from(map).mapValues(this::convertNonNull).collect((Object)Struct.newBuilder(), Struct.Builder::putFields)).build();
    }

    public final Struct nestedStruct(Table<String, String, ?> table) {
        return ((Struct.Builder)BiStream.from((Map)table.rowMap()).mapValues(cols -> MoreValues.valueOf(this.struct((Map<String, ?>)cols))).collect((Object)Struct.newBuilder(), Struct.Builder::putFields)).build();
    }

    public final BiCollector<CharSequence, Object, Struct> toStruct() {
        return this::toStruct;
    }

    public Value toValue(@Nullable Object object) {
        if (object == null || object instanceof NullValue) {
            return MoreValues.NULL;
        }
        if (object instanceof Boolean) {
            return MoreValues.valueOf((Boolean)object);
        }
        if (object instanceof Number) {
            return MoreValues.valueOf(((Number)object).doubleValue());
        }
        if (object instanceof CharSequence) {
            return MoreValues.valueOf(object.toString());
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Struct) {
            return MoreValues.valueOf((Struct)object);
        }
        if (object instanceof ListValue) {
            return MoreValues.valueOf((ListValue)object);
        }
        if (object instanceof Iterable) {
            ListValue.Builder builder = ListValue.newBuilder();
            for (Object element : (Iterable)object) {
                builder.addValues(this.convertNonNull(element));
            }
            return MoreValues.valueOf(builder.build());
        }
        if (object instanceof Map) {
            return this.toStructValue((Map)object);
        }
        if (object instanceof Multimap) {
            return this.toStructValue(((Multimap)object).asMap());
        }
        if (object instanceof Table) {
            return this.toStructValue(((Table)object).rowMap());
        }
        if (object instanceof Optional) {
            return this.convertNonNull(((Optional)object).orElse(null));
        }
        if (object instanceof Enum) {
            return MoreValues.valueOf(((Enum)object).name());
        }
        if (object instanceof int[]) {
            return Arrays.stream((int[])object).mapToObj(MoreValues::valueOf).collect(Structor.valuesToValue());
        }
        if (object instanceof ImmutableIntArray) {
            ImmutableIntArray array = (ImmutableIntArray)object;
            return IntStream.range(0, array.length()).mapToObj(i -> MoreValues.valueOf(array.get(i))).collect(Structor.valuesToValue());
        }
        if (object instanceof long[]) {
            return Arrays.stream((long[])object).mapToObj(MoreValues::valueOf).collect(Structor.valuesToValue());
        }
        if (object instanceof ImmutableLongArray) {
            ImmutableLongArray array = (ImmutableLongArray)object;
            return IntStream.range(0, array.length()).mapToObj(i -> MoreValues.valueOf(array.get(i))).collect(Structor.valuesToValue());
        }
        if (object instanceof double[]) {
            return Arrays.stream((double[])object).mapToObj(MoreValues::valueOf).collect(Structor.valuesToValue());
        }
        if (object instanceof ImmutableDoubleArray) {
            ImmutableDoubleArray array = (ImmutableDoubleArray)object;
            return IntStream.range(0, array.length()).mapToObj(i -> MoreValues.valueOf(array.get(i))).collect(Structor.valuesToValue());
        }
        if (object instanceof Object[]) {
            return Arrays.stream((Object[])object).map(this::convertNonNull).collect(Structor.valuesToValue());
        }
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            return IntStream.range(0, array.length).mapToObj(i -> MoreValues.valueOf(array[i])).collect(Structor.valuesToValue());
        }
        if (object instanceof short[]) {
            short[] array = (short[])object;
            return IntStream.range(0, array.length).mapToObj(i -> MoreValues.valueOf(array[i])).collect(Structor.valuesToValue());
        }
        return this.defaultValue(object);
    }

    protected Value defaultValue(Object object) {
        throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
    }

    private <T> Collector<T, ?, Struct> toStruct(Function<T, CharSequence> keyFunction, Function<T, ?> valueFunction) {
        return MoreStructs.toStruct(keyFunction, valueFunction.andThen(this::convertNonNull));
    }

    private Value convertNonNull(@Nullable Object object) {
        return (Value)Preconditions.checkNotNull((Object)this.toValue(object), (Object)"Cannot convert to null. Consider converting to NullValue instead.");
    }

    private Value toStructValue(Map<?, ?> map) {
        return MoreValues.valueOf((Struct)BiStream.from(map).mapKeys(Structor::toStructKey).mapValues(this::convertNonNull).collect(this.toStruct()));
    }

    private static String toStructKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"Struct key cannot be null");
        Preconditions.checkArgument((boolean)(key instanceof CharSequence), (String)"Unsupported struct key type: %s", (Object)key.getClass().getName());
        return key.toString();
    }

    private static Collector<Value, ?, Value> valuesToValue() {
        return Collectors.collectingAndThen(MoreValues.toListValue(), MoreValues::valueOf);
    }
}

