/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.merchant.promotions.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.shopping.merchant.promotions.v1beta.GetPromotionRequest;
import com.google.shopping.merchant.promotions.v1beta.InsertPromotionRequest;
import com.google.shopping.merchant.promotions.v1beta.ListPromotionsRequest;
import com.google.shopping.merchant.promotions.v1beta.ListPromotionsResponse;
import com.google.shopping.merchant.promotions.v1beta.Promotion;
import com.google.shopping.merchant.promotions.v1beta.PromotionName;
import com.google.shopping.merchant.promotions.v1beta.PromotionsServiceSettings;
import com.google.shopping.merchant.promotions.v1beta.stub.PromotionsServiceStub;
import com.google.shopping.merchant.promotions.v1beta.stub.PromotionsServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PromotionsServiceClient
implements BackgroundResource {
    private final PromotionsServiceSettings settings;
    private final PromotionsServiceStub stub;

    public static final PromotionsServiceClient create() throws IOException {
        return PromotionsServiceClient.create(PromotionsServiceSettings.newBuilder().build());
    }

    public static final PromotionsServiceClient create(PromotionsServiceSettings settings) throws IOException {
        return new PromotionsServiceClient(settings);
    }

    public static final PromotionsServiceClient create(PromotionsServiceStub stub) {
        return new PromotionsServiceClient(stub);
    }

    protected PromotionsServiceClient(PromotionsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PromotionsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PromotionsServiceClient(PromotionsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PromotionsServiceSettings getSettings() {
        return this.settings;
    }

    public PromotionsServiceStub getStub() {
        return this.stub;
    }

    public final Promotion insertPromotion(InsertPromotionRequest request) {
        return (Promotion)this.insertPromotionCallable().call((Object)request);
    }

    public final UnaryCallable<InsertPromotionRequest, Promotion> insertPromotionCallable() {
        return this.stub.insertPromotionCallable();
    }

    public final Promotion getPromotion(PromotionName name) {
        GetPromotionRequest request = GetPromotionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPromotion(request);
    }

    public final Promotion getPromotion(String name) {
        GetPromotionRequest request = GetPromotionRequest.newBuilder().setName(name).build();
        return this.getPromotion(request);
    }

    public final Promotion getPromotion(GetPromotionRequest request) {
        return (Promotion)this.getPromotionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPromotionRequest, Promotion> getPromotionCallable() {
        return this.stub.getPromotionCallable();
    }

    public final ListPromotionsPagedResponse listPromotions(String parent) {
        ListPromotionsRequest request = ListPromotionsRequest.newBuilder().setParent(parent).build();
        return this.listPromotions(request);
    }

    public final ListPromotionsPagedResponse listPromotions(ListPromotionsRequest request) {
        return (ListPromotionsPagedResponse)((Object)this.listPromotionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPromotionsRequest, ListPromotionsPagedResponse> listPromotionsPagedCallable() {
        return this.stub.listPromotionsPagedCallable();
    }

    public final UnaryCallable<ListPromotionsRequest, ListPromotionsResponse> listPromotionsCallable() {
        return this.stub.listPromotionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPromotionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPromotionsRequest, ListPromotionsResponse, Promotion, ListPromotionsPage, ListPromotionsFixedSizeCollection> {
        private ListPromotionsFixedSizeCollection(List<ListPromotionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPromotionsFixedSizeCollection createEmptyCollection() {
            return new ListPromotionsFixedSizeCollection(null, 0);
        }

        protected ListPromotionsFixedSizeCollection createCollection(List<ListPromotionsPage> pages, int collectionSize) {
            return new ListPromotionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPromotionsPage
    extends AbstractPage<ListPromotionsRequest, ListPromotionsResponse, Promotion, ListPromotionsPage> {
        private ListPromotionsPage(PageContext<ListPromotionsRequest, ListPromotionsResponse, Promotion> context, ListPromotionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPromotionsPage createEmptyPage() {
            return new ListPromotionsPage(null, null);
        }

        protected ListPromotionsPage createPage(PageContext<ListPromotionsRequest, ListPromotionsResponse, Promotion> context, ListPromotionsResponse response) {
            return new ListPromotionsPage(context, response);
        }

        public ApiFuture<ListPromotionsPage> createPageAsync(PageContext<ListPromotionsRequest, ListPromotionsResponse, Promotion> context, ApiFuture<ListPromotionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPromotionsPagedResponse
    extends AbstractPagedListResponse<ListPromotionsRequest, ListPromotionsResponse, Promotion, ListPromotionsPage, ListPromotionsFixedSizeCollection> {
        public static ApiFuture<ListPromotionsPagedResponse> createAsync(PageContext<ListPromotionsRequest, ListPromotionsResponse, Promotion> context, ApiFuture<ListPromotionsResponse> futureResponse) {
            ApiFuture<ListPromotionsPage> futurePage = ListPromotionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPromotionsPagedResponse((ListPromotionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPromotionsPagedResponse(ListPromotionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPromotionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

