/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.merchant.promotions.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.shopping.merchant.promotions.v1beta.GetPromotionRequest;
import com.google.shopping.merchant.promotions.v1beta.InsertPromotionRequest;
import com.google.shopping.merchant.promotions.v1beta.ListPromotionsRequest;
import com.google.shopping.merchant.promotions.v1beta.ListPromotionsResponse;
import com.google.shopping.merchant.promotions.v1beta.Promotion;
import com.google.shopping.merchant.promotions.v1beta.PromotionsServiceClient;
import com.google.shopping.merchant.promotions.v1beta.stub.GrpcPromotionsServiceStub;
import com.google.shopping.merchant.promotions.v1beta.stub.HttpJsonPromotionsServiceStub;
import com.google.shopping.merchant.promotions.v1beta.stub.PromotionsServiceStub;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class PromotionsServiceStubSettings
extends StubSettings<PromotionsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/content").build();
    private final UnaryCallSettings<InsertPromotionRequest, Promotion> insertPromotionSettings;
    private final UnaryCallSettings<GetPromotionRequest, Promotion> getPromotionSettings;
    private final PagedCallSettings<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse> listPromotionsSettings;
    private static final PagedListDescriptor<ListPromotionsRequest, ListPromotionsResponse, Promotion> LIST_PROMOTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPromotionsRequest, ListPromotionsResponse, Promotion>(){

        public String emptyToken() {
            return "";
        }

        public ListPromotionsRequest injectToken(ListPromotionsRequest payload, String token) {
            return ListPromotionsRequest.newBuilder((ListPromotionsRequest)payload).setPageToken(token).build();
        }

        public ListPromotionsRequest injectPageSize(ListPromotionsRequest payload, int pageSize) {
            return ListPromotionsRequest.newBuilder((ListPromotionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPromotionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPromotionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Promotion> extractResources(ListPromotionsResponse payload) {
            return payload.getPromotionsList();
        }
    };
    private static final PagedListResponseFactory<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse> LIST_PROMOTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse>(){

        public ApiFuture<PromotionsServiceClient.ListPromotionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPromotionsRequest, ListPromotionsResponse> callable, ListPromotionsRequest request, ApiCallContext context, ApiFuture<ListPromotionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROMOTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PromotionsServiceClient.ListPromotionsPagedResponse.createAsync((PageContext<ListPromotionsRequest, ListPromotionsResponse, Promotion>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<InsertPromotionRequest, Promotion> insertPromotionSettings() {
        return this.insertPromotionSettings;
    }

    public UnaryCallSettings<GetPromotionRequest, Promotion> getPromotionSettings() {
        return this.getPromotionSettings;
    }

    public PagedCallSettings<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse> listPromotionsSettings() {
        return this.listPromotionsSettings;
    }

    public PromotionsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPromotionsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPromotionsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "merchantapi";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "merchantapi.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "merchantapi.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PromotionsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PromotionsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PromotionsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PromotionsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PromotionsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.insertPromotionSettings = settingsBuilder.insertPromotionSettings().build();
        this.getPromotionSettings = settingsBuilder.getPromotionSettings().build();
        this.listPromotionsSettings = settingsBuilder.listPromotionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PromotionsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<InsertPromotionRequest, Promotion> insertPromotionSettings;
        private final UnaryCallSettings.Builder<GetPromotionRequest, Promotion> getPromotionSettings;
        private final PagedCallSettings.Builder<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse> listPromotionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.insertPromotionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPromotionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPromotionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROMOTIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.insertPromotionSettings, this.getPromotionSettings, this.listPromotionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PromotionsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.insertPromotionSettings = settings.insertPromotionSettings.toBuilder();
            this.getPromotionSettings = settings.getPromotionSettings.toBuilder();
            this.listPromotionsSettings = settings.listPromotionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.insertPromotionSettings, this.getPromotionSettings, this.listPromotionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PromotionsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PromotionsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PromotionsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PromotionsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PromotionsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PromotionsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PromotionsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PromotionsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.insertPromotionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPromotionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPromotionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<InsertPromotionRequest, Promotion> insertPromotionSettings() {
            return this.insertPromotionSettings;
        }

        public UnaryCallSettings.Builder<GetPromotionRequest, Promotion> getPromotionSettings() {
            return this.getPromotionSettings;
        }

        public PagedCallSettings.Builder<ListPromotionsRequest, ListPromotionsResponse, PromotionsServiceClient.ListPromotionsPagedResponse> listPromotionsSettings() {
            return this.listPromotionsSettings;
        }

        public PromotionsServiceStubSettings build() throws IOException {
            return new PromotionsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

