/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.merchant.reports.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import com.google.shopping.merchant.reports.v1beta.ReportServiceClient;
import com.google.shopping.merchant.reports.v1beta.SearchRequest;
import com.google.shopping.merchant.reports.v1beta.SearchResponse;
import com.google.shopping.merchant.reports.v1beta.stub.GrpcReportServiceCallableFactory;
import com.google.shopping.merchant.reports.v1beta.stub.ReportServiceStub;
import com.google.shopping.merchant.reports.v1beta.stub.ReportServiceStubSettings;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcReportServiceStub
extends ReportServiceStub {
    private static final MethodDescriptor<SearchRequest, SearchResponse> searchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.merchant.reports.v1beta.ReportService/Search").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchResponse.getDefaultInstance())).build();
    private final UnaryCallable<SearchRequest, SearchResponse> searchCallable;
    private final UnaryCallable<SearchRequest, ReportServiceClient.SearchPagedResponse> searchPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcReportServiceStub create(ReportServiceStubSettings settings) throws IOException {
        return new GrpcReportServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcReportServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcReportServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcReportServiceCallableFactory());
    }

    protected GrpcReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.searchCallable = callableFactory.createUnaryCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchPagedCallable = callableFactory.createPagedCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.searchCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, ReportServiceClient.SearchPagedResponse> searchPagedCallable() {
        return this.searchPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

