/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.merchant.reports.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.shopping.merchant.reports.v1beta.ReportRow;
import com.google.shopping.merchant.reports.v1beta.ReportServiceSettings;
import com.google.shopping.merchant.reports.v1beta.SearchRequest;
import com.google.shopping.merchant.reports.v1beta.SearchResponse;
import com.google.shopping.merchant.reports.v1beta.stub.ReportServiceStub;
import com.google.shopping.merchant.reports.v1beta.stub.ReportServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ReportServiceClient
implements BackgroundResource {
    private final ReportServiceSettings settings;
    private final ReportServiceStub stub;

    public static final ReportServiceClient create() throws IOException {
        return ReportServiceClient.create(ReportServiceSettings.newBuilder().build());
    }

    public static final ReportServiceClient create(ReportServiceSettings settings) throws IOException {
        return new ReportServiceClient(settings);
    }

    public static final ReportServiceClient create(ReportServiceStub stub) {
        return new ReportServiceClient(stub);
    }

    protected ReportServiceClient(ReportServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReportServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ReportServiceClient(ReportServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReportServiceSettings getSettings() {
        return this.settings;
    }

    public ReportServiceStub getStub() {
        return this.stub;
    }

    public final SearchPagedResponse search(String parent) {
        SearchRequest request = SearchRequest.newBuilder().setParent(parent).build();
        return this.search(request);
    }

    public final SearchPagedResponse search(SearchRequest request) {
        return (SearchPagedResponse)((Object)this.searchPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchRequest, SearchPagedResponse> searchPagedCallable() {
        return this.stub.searchPagedCallable();
    }

    public final UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.stub.searchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchRequest, SearchResponse, ReportRow, SearchPage, SearchFixedSizeCollection> {
        private SearchFixedSizeCollection(List<SearchPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchFixedSizeCollection createEmptyCollection() {
            return new SearchFixedSizeCollection(null, 0);
        }

        protected SearchFixedSizeCollection createCollection(List<SearchPage> pages, int collectionSize) {
            return new SearchFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchPage
    extends AbstractPage<SearchRequest, SearchResponse, ReportRow, SearchPage> {
        private SearchPage(PageContext<SearchRequest, SearchResponse, ReportRow> context, SearchResponse response) {
            super(context, (Object)response);
        }

        private static SearchPage createEmptyPage() {
            return new SearchPage(null, null);
        }

        protected SearchPage createPage(PageContext<SearchRequest, SearchResponse, ReportRow> context, SearchResponse response) {
            return new SearchPage(context, response);
        }

        public ApiFuture<SearchPage> createPageAsync(PageContext<SearchRequest, SearchResponse, ReportRow> context, ApiFuture<SearchResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchPagedResponse
    extends AbstractPagedListResponse<SearchRequest, SearchResponse, ReportRow, SearchPage, SearchFixedSizeCollection> {
        public static ApiFuture<SearchPagedResponse> createAsync(PageContext<SearchRequest, SearchResponse, ReportRow> context, ApiFuture<SearchResponse> futureResponse) {
            ApiFuture<SearchPage> futurePage = SearchPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchPagedResponse((SearchPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchPagedResponse(SearchPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchFixedSizeCollection.createEmptyCollection());
        }
    }
}

