/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.config;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.tsunami.common.config.TsunamiConfig;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;

public final class ConfigModule
extends AbstractModule {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String CONFIG_PROPERTIES_ANNOTATION = "com.google.tsunami.common.config.annotations.ConfigProperties";
    private final ScanResult scanResult;
    private final TsunamiConfig tsunamiConfig;

    public ConfigModule(ScanResult scanResult, TsunamiConfig tsunamiConfig) {
        this.scanResult = (ScanResult)Preconditions.checkNotNull((Object)scanResult);
        this.tsunamiConfig = (TsunamiConfig)Preconditions.checkNotNull((Object)tsunamiConfig);
    }

    protected void configure() {
        this.bind(TsunamiConfig.class).toInstance((Object)this.tsunamiConfig);
        for (ClassInfo configClass : this.scanResult.getClassesWithAnnotation(CONFIG_PROPERTIES_ANNOTATION).filter(classInfo -> !classInfo.isAbstract())) {
            ((GoogleLogger.Api)logger.atInfo()).log("Found Tsunami config class: %s", (Object)configClass.getName());
            this.bindConfigClass(ConfigModule.getConfigPrefix(configClass), configClass.loadClass());
        }
    }

    private <T> void bindConfigClass(String configPrefix, Class<T> configClass) {
        T configObject = this.tsunamiConfig.getConfig(configPrefix, configClass);
        this.bind(configClass).toInstance(configObject);
    }

    private static String getConfigPrefix(ClassInfo configClass) {
        Object configPrefix = configClass.getAnnotationInfo(CONFIG_PROPERTIES_ANNOTATION).getParameterValues().getValue("value");
        if (!(configPrefix instanceof String)) {
            throw new AssertionError((Object)"SHOULD NEVER HAPPEN, ConfigProperties value is not a string.");
        }
        return (String)configPrefix;
    }
}

