/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.tsunami.common.config.ConfigException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;

public final class TsunamiConfig {
    private static final Converter<String, String> FIELD_NAME_TO_LOWER_UNDERSCORE = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
    private static final Splitter CONFIG_PATH_SPLITTER = Splitter.on((char)'.').omitEmptyStrings();
    private final ImmutableMap<String, Object> rawConfigData;

    private TsunamiConfig(ImmutableMap<String, Object> rawConfigData) {
        this.rawConfigData = (ImmutableMap)Preconditions.checkNotNull(rawConfigData);
    }

    public ImmutableMap<String, Object> getRawConfigData() {
        return this.rawConfigData;
    }

    public static TsunamiConfig fromYamlData(Map<String, Object> yamlConfig) {
        return new TsunamiConfig((ImmutableMap<String, Object>)(yamlConfig == null ? ImmutableMap.of() : ImmutableMap.copyOf(yamlConfig)));
    }

    public static Optional<String> getSystemProperty(String propertyName) {
        return Optional.ofNullable(TsunamiConfig.getSystemProperty(propertyName, null));
    }

    public static String getSystemProperty(String propertyName, String def) {
        return System.getProperty(propertyName, def);
    }

    public <T> T getConfig(String configPrefix, Class<T> clazz) {
        Preconditions.checkNotNull((Object)configPrefix);
        Preconditions.checkNotNull(clazz);
        ImmutableMap<String, Object> configValue = this.readConfigValue(configPrefix);
        return TsunamiConfig.newConfigObject(clazz, configValue);
    }

    public ImmutableMap<String, Object> readConfigValue(String configPrefix) {
        Object retrievedData = this.rawConfigData;
        for (String configKey : CONFIG_PATH_SPLITTER.split((CharSequence)configPrefix)) {
            if (!retrievedData.containsKey(configKey)) {
                return ImmutableMap.of();
            }
            Object configData = retrievedData.get(configKey);
            if (!(configData instanceof Map)) {
                throw new ConfigException(String.format("Unexpected data type for config '%s', expected '%s', got '%s'", configKey, Map.class, configData.getClass()));
            }
            retrievedData = (Map)configData;
        }
        return ImmutableMap.copyOf(retrievedData);
    }

    private static <T> T newConfigObject(Class<T> clazz, Map<String, Object> configValue) {
        try {
            Constructor<T> configObjectCtor = clazz.getDeclaredConstructor(new Class[0]);
            configObjectCtor.setAccessible(true);
            T configObject = configObjectCtor.newInstance(new Object[0]);
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!configValue.containsKey(fieldName) && !configValue.containsKey(FIELD_NAME_TO_LOWER_UNDERSCORE.convert((Object)fieldName))) continue;
                Object fieldValue = Optional.ofNullable(configValue.get(fieldName)).orElse(configValue.get(FIELD_NAME_TO_LOWER_UNDERSCORE.convert((Object)fieldName)));
                field.setAccessible(true);
                field.set(configObject, fieldValue);
            }
            return configObject;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError(String.format("Unable to create new instance of '%s' using config value '%s'", clazz, configValue), e);
        }
    }
}

