/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.config;

import com.google.common.flogger.GoogleLogger;
import com.google.common.io.Files;
import com.google.tsunami.common.config.ConfigLoader;
import com.google.tsunami.common.config.TsunamiConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class YamlConfigLoader
implements ConfigLoader {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String DEFAULT_CONFIG_FILE = "tsunami.yaml";

    @Override
    public TsunamiConfig loadConfig() {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Map rawYamlData = (Map)yaml.load(YamlConfigLoader.configFileReader());
        return TsunamiConfig.fromYamlData(rawYamlData);
    }

    private static Reader configFileReader() {
        String configFile = TsunamiConfig.getSystemProperty("tsunami.config.location").orElse(DEFAULT_CONFIG_FILE);
        try {
            return Files.newReader((File)new File(configFile), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            ((GoogleLogger.Api)logger.atWarning()).log("Unable to read config file '%s', default to empty config.", (Object)configFile);
            return new StringReader("");
        }
    }
}

