/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.data;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.tsunami.proto.AddressFamily;
import com.google.tsunami.proto.Hostname;
import com.google.tsunami.proto.IpAddress;
import com.google.tsunami.proto.NetworkEndpoint;
import com.google.tsunami.proto.Port;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public final class NetworkEndpointUtils {
    public static final int MAX_PORT_NUMBER = 65535;

    private NetworkEndpointUtils() {
    }

    public static boolean hasIpAddress(NetworkEndpoint networkEndpoint) {
        return networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_PORT) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_HOSTNAME) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_HOSTNAME_PORT);
    }

    public static boolean hasHostname(NetworkEndpoint networkEndpoint) {
        return networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.HOSTNAME) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.HOSTNAME_PORT) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_HOSTNAME) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_HOSTNAME_PORT);
    }

    public static boolean hasPort(NetworkEndpoint networkEndpoint) {
        return networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_PORT) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.HOSTNAME_PORT) || networkEndpoint.getType().equals((Object)NetworkEndpoint.Type.IP_HOSTNAME_PORT);
    }

    public static boolean isIpV6Endpoint(NetworkEndpoint networkEndpoint) {
        return NetworkEndpointUtils.hasIpAddress(networkEndpoint) && networkEndpoint.getIpAddress().getAddressFamily().equals((Object)AddressFamily.IPV6);
    }

    public static String toUriAuthority(NetworkEndpoint networkEndpoint) {
        return NetworkEndpointUtils.toHostAndPort(networkEndpoint).toString();
    }

    public static HostAndPort toHostAndPort(NetworkEndpoint networkEndpoint) {
        switch (networkEndpoint.getType()) {
            case IP: {
                return HostAndPort.fromHost((String)networkEndpoint.getIpAddress().getAddress());
            }
            case IP_PORT: {
                return HostAndPort.fromParts((String)networkEndpoint.getIpAddress().getAddress(), (int)networkEndpoint.getPort().getPortNumber());
            }
            case HOSTNAME: 
            case IP_HOSTNAME: {
                return HostAndPort.fromHost((String)networkEndpoint.getHostname().getName());
            }
            case HOSTNAME_PORT: 
            case IP_HOSTNAME_PORT: {
                return HostAndPort.fromParts((String)networkEndpoint.getHostname().getName(), (int)networkEndpoint.getPort().getPortNumber());
            }
            case UNRECOGNIZED: 
            case TYPE_UNSPECIFIED: {
                throw new AssertionError((Object)"Type for NetworkEndpoint must be specified.");
            }
        }
        throw new AssertionError((Object)String.format("Should never happen. Unchecked NetworkEndpoint type: %s", networkEndpoint.getType()));
    }

    public static NetworkEndpoint forIp(String ipAddress) {
        Preconditions.checkArgument((boolean)InetAddresses.isInetAddress((String)ipAddress), (String)"'%s' is not an IP address.", (Object)ipAddress);
        return NetworkEndpoint.newBuilder().setType(NetworkEndpoint.Type.IP).setIpAddress(IpAddress.newBuilder().setAddressFamily(NetworkEndpointUtils.ipAddressFamily(ipAddress)).setAddress(ipAddress)).build();
    }

    public static NetworkEndpoint forIpAndPort(String ipAddress, int port) {
        Preconditions.checkArgument((boolean)InetAddresses.isInetAddress((String)ipAddress), (String)"'%s' is not an IP address.", (Object)ipAddress);
        Preconditions.checkArgument((0 <= port && port <= 65535 ? 1 : 0) != 0, (String)"Port out of range. Expected [0, %s], actual %s.", (int)65535, (int)port);
        return NetworkEndpointUtils.forIp(ipAddress).toBuilder().setType(NetworkEndpoint.Type.IP_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
    }

    public static NetworkEndpoint forHostname(String hostname) {
        Preconditions.checkArgument((!InetAddresses.isInetAddress((String)hostname) ? 1 : 0) != 0, (String)"Expected hostname, got IP address '%s'", (Object)hostname);
        return NetworkEndpoint.newBuilder().setType(NetworkEndpoint.Type.HOSTNAME).setHostname(Hostname.newBuilder().setName(hostname)).build();
    }

    public static NetworkEndpoint forIpAndHostname(String ipAddress, String hostname) {
        return NetworkEndpointUtils.forIp(ipAddress).toBuilder().setType(NetworkEndpoint.Type.IP_HOSTNAME).setHostname(Hostname.newBuilder().setName(hostname)).build();
    }

    public static NetworkEndpoint forHostnameAndPort(String hostname, int port) {
        Preconditions.checkArgument((0 <= port && port <= 65535 ? 1 : 0) != 0, (String)"Port out of range. Expected [0, %s], actual %s.", (int)65535, (int)port);
        return NetworkEndpointUtils.forHostname(hostname).toBuilder().setType(NetworkEndpoint.Type.HOSTNAME_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
    }

    public static NetworkEndpoint forIpHostnameAndPort(String ipAddress, String hostname, int port) {
        Preconditions.checkArgument((0 <= port && port <= 65535 ? 1 : 0) != 0, (String)"Port out of range. Expected [0, %s], actual %s.", (int)65535, (int)port);
        return NetworkEndpointUtils.forIpAndHostname(ipAddress, hostname).toBuilder().setType(NetworkEndpoint.Type.IP_HOSTNAME_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
    }

    public static NetworkEndpoint forNetworkEndpointAndPort(NetworkEndpoint networkEndpoint, int port) {
        Preconditions.checkNotNull((Object)networkEndpoint);
        Preconditions.checkArgument((0 <= port && port <= 65535 ? 1 : 0) != 0, (String)"Port out of range. Expected [0, %s], actual %s.", (int)65535, (int)port);
        switch (networkEndpoint.getType()) {
            case IP: {
                return networkEndpoint.toBuilder().setType(NetworkEndpoint.Type.IP_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
            }
            case HOSTNAME: {
                return networkEndpoint.toBuilder().setType(NetworkEndpoint.Type.HOSTNAME_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
            }
            case IP_HOSTNAME: {
                return networkEndpoint.toBuilder().setType(NetworkEndpoint.Type.IP_HOSTNAME_PORT).setPort(Port.newBuilder().setPortNumber(port)).build();
            }
            case IP_PORT: 
            case HOSTNAME_PORT: 
            case IP_HOSTNAME_PORT: 
            case UNRECOGNIZED: 
            case TYPE_UNSPECIFIED: {
                throw new IllegalArgumentException("Invalid NetworkEndpoint type.");
            }
        }
        throw new AssertionError((Object)String.format("Should never happen. Unchecked NetworkEndpoint type: %s", networkEndpoint.getType()));
    }

    public static AddressFamily ipAddressFamily(String ipAddress) {
        InetAddress inetAddress = InetAddresses.forString((String)ipAddress);
        if (inetAddress instanceof Inet4Address) {
            return AddressFamily.IPV4;
        }
        if (inetAddress instanceof Inet6Address) {
            return AddressFamily.IPV6;
        }
        throw new AssertionError((Object)String.format("Unknown IP address family for IP '%s'", ipAddress));
    }
}

