/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.data;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.tsunami.common.data.NetworkEndpointUtils;
import com.google.tsunami.proto.AddressFamily;
import com.google.tsunami.proto.Hostname;
import com.google.tsunami.proto.IpAddress;
import com.google.tsunami.proto.NetworkEndpoint;
import com.google.tsunami.proto.NetworkService;
import com.google.tsunami.proto.Port;
import com.google.tsunami.proto.ServiceContext;
import com.google.tsunami.proto.TransportProtocol;
import com.google.tsunami.proto.WebServiceContext;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Optional;

public final class NetworkServiceUtils {
    private static final ImmutableMap<String, Boolean> IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME = ImmutableMap.builder().put((Object)"http", (Object)true).put((Object)"http-alt", (Object)true).put((Object)"http-proxy", (Object)true).put((Object)"https", (Object)false).put((Object)"radan-http", (Object)true).put((Object)"ssl/http", (Object)false).put((Object)"ssl/https", (Object)false).put((Object)"ssl/http-proxy", (Object)false).put((Object)"ssl/tungsten-https", (Object)false).put((Object)"ssl/wso2esb-console", (Object)false).build();

    private NetworkServiceUtils() {
    }

    public static boolean isWebService(Optional<String> serviceName) {
        return serviceName.isPresent() && IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME.containsKey((Object)Ascii.toLowerCase((String)serviceName.get()));
    }

    public static boolean isWebService(NetworkService networkService) {
        Preconditions.checkNotNull((Object)networkService);
        return networkService.getSupportedHttpMethodsCount() > 0 || NetworkServiceUtils.isWebService(Optional.of(networkService.getServiceName()));
    }

    public static boolean isPlainHttp(NetworkService networkService) {
        boolean doesNotSupportAnySslVersion;
        Preconditions.checkNotNull((Object)networkService);
        boolean isWebService = NetworkServiceUtils.isWebService(networkService);
        boolean isKnownServiceName = IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME.containsKey((Object)Ascii.toLowerCase((String)networkService.getServiceName()));
        boolean bl = doesNotSupportAnySslVersion = networkService.getSupportedSslVersionsCount() == 0;
        if (!isKnownServiceName) {
            return isWebService && doesNotSupportAnySslVersion;
        }
        Boolean isKnownPlainHttpService = (Boolean)IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME.getOrDefault((Object)Ascii.toLowerCase((String)networkService.getServiceName()), (Object)false);
        return isKnownPlainHttpService != false && doesNotSupportAnySslVersion;
    }

    public static String getServiceName(NetworkService networkService) {
        if (NetworkServiceUtils.isWebService(networkService) && networkService.hasSoftware()) {
            return Ascii.toLowerCase((String)networkService.getSoftware().getName());
        }
        return Ascii.toLowerCase((String)networkService.getServiceName());
    }

    public static String getWebServiceName(NetworkService networkService) {
        if (NetworkServiceUtils.isWebService(networkService) && networkService.getServiceContext().getWebServiceContext().hasSoftware()) {
            return Ascii.toLowerCase((String)networkService.getServiceContext().getWebServiceContext().getSoftware().getName());
        }
        return Ascii.toLowerCase((String)networkService.getServiceName());
    }

    public static NetworkService buildUriNetworkService(String uriString) {
        try {
            URI uri = new URI(uriString);
            NetworkEndpoint uriEndPoint = NetworkServiceUtils.buildUriNetworkEndPoint(uri);
            return NetworkService.newBuilder().setNetworkEndpoint(uriEndPoint).setTransportProtocol(TransportProtocol.TCP).setServiceName(uri.getScheme()).setServiceContext(ServiceContext.newBuilder().setWebServiceContext(WebServiceContext.newBuilder().setApplicationRoot(uri.getPath()))).build();
        }
        catch (URISyntaxException exception) {
            throw new AssertionError((Object)String.format("Invalid uri syntax passed as target '%s'. Error: %s", uriString, exception));
        }
    }

    private static NetworkEndpoint buildUriNetworkEndPoint(URI uri) {
        try {
            String hostname = uri.getHost();
            String scheme = uri.getScheme();
            Preconditions.checkArgument((scheme.equals("http") || scheme.equals("https") ? 1 : 0) != 0, (Object)"Uri scheme should be one of the following: 'http', 'https'");
            int port = uri.getPort();
            if (port < 0) {
                port = scheme.equals("http") ? 80 : 443;
            }
            String ipAddress = InetAddress.getByName(hostname).getHostAddress();
            InetAddress inetAddress = InetAddress.getByName(uri.getHost());
            Preconditions.checkArgument((inetAddress instanceof Inet4Address || inetAddress instanceof Inet6Address ? 1 : 0) != 0, (Object)"Invalid address family");
            AddressFamily addressFamily = inetAddress instanceof Inet4Address ? AddressFamily.IPV4 : AddressFamily.IPV6;
            return NetworkEndpoint.newBuilder().setType(NetworkEndpoint.Type.IP_HOSTNAME_PORT).setPort(Port.newBuilder().setPortNumber(port)).setHostname(Hostname.newBuilder().setName(uri.getHost())).setIpAddress(IpAddress.newBuilder().setAddressFamily(addressFamily).setAddress(ipAddress)).build();
        }
        catch (UnknownHostException exception) {
            throw new AssertionError((Object)String.format("Unable to get valid host from uri. Error: %s", exception));
        }
    }

    public static String buildWebApplicationRootUrl(NetworkService networkService) {
        Preconditions.checkNotNull((Object)networkService);
        if (!NetworkServiceUtils.isWebService(networkService)) {
            return "http://" + NetworkEndpointUtils.toUriAuthority(networkService.getNetworkEndpoint()) + "/";
        }
        String rootUrl = (NetworkServiceUtils.isPlainHttp(networkService) ? "http://" : "https://") + NetworkServiceUtils.buildWebUriAuthority(networkService) + NetworkServiceUtils.buildWebAppRootPath(networkService);
        return rootUrl.endsWith("/") ? rootUrl : rootUrl + "/";
    }

    private static String buildWebAppRootPath(NetworkService networkService) {
        Object rootPath;
        Object object = rootPath = networkService.getServiceContext().hasWebServiceContext() ? networkService.getServiceContext().getWebServiceContext().getApplicationRoot() : "/";
        if (!((String)rootPath).startsWith("/")) {
            rootPath = "/" + (String)rootPath;
        }
        return rootPath;
    }

    private static String buildWebUriAuthority(NetworkService networkService) {
        String uriAuthority = NetworkEndpointUtils.toUriAuthority(networkService.getNetworkEndpoint());
        boolean isPlainHttp = NetworkServiceUtils.isPlainHttp(networkService);
        if (isPlainHttp && uriAuthority.endsWith(":80")) {
            uriAuthority = uriAuthority.substring(0, uriAuthority.lastIndexOf(":80"));
        }
        if (!isPlainHttp && uriAuthority.endsWith(":443")) {
            uriAuthority = uriAuthority.substring(0, uriAuthority.lastIndexOf(":443"));
        }
        return uriAuthority;
    }
}

