/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.io.archiving;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.assistedinject.Assisted;
import com.google.tsunami.common.cli.CliOption;
import com.google.tsunami.common.io.archiving.Archiver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class GoogleCloudStorageArchiver
implements Archiver {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final Pattern GS_URL_PATTERN = Pattern.compile("gs://([^/]{3,63})/(.*)");
    private final Options options;
    private final Storage storage;

    @Inject
    public GoogleCloudStorageArchiver(Options options, @Assisted Storage storage) {
        this.options = (Options)Preconditions.checkNotNull((Object)options);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
    }

    private static BlobInfo parseBlobInfo(String gcsUrl) {
        Matcher matcher = GS_URL_PATTERN.matcher(gcsUrl);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid GCS URL: '%s'", (Object)gcsUrl);
        String bucketName = matcher.group(1);
        String objectName = matcher.group(2);
        return BlobInfo.newBuilder((String)bucketName, (String)objectName).build();
    }

    @Override
    public boolean archive(String gcsUrl, byte[] data) {
        boolean bl;
        block10: {
            BlobInfo blobInfo = GoogleCloudStorageArchiver.parseBlobInfo(gcsUrl);
            if (data.length <= this.options.chunkUploadThresholdInBytes) {
                ((GoogleLogger.Api)logger.atInfo()).log("Archiving data to GCS at '%s' in one request.", (Object)gcsUrl);
                this.storage.create(blobInfo, data, new Storage.BlobTargetOption[0]);
                return true;
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Content is larger than threshold, archiving data to GCS at '%s' in chunks.", (Object)gcsUrl);
            WriteChannel writer = this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);
            try {
                for (int chunkOffset = 0; chunkOffset < data.length; chunkOffset += this.options.chunkSizeInBytes) {
                    int chunkSize = Math.min(data.length - chunkOffset, this.options.chunkSizeInBytes);
                    writer.write(ByteBuffer.wrap(data, chunkOffset, chunkSize));
                }
                bl = true;
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Unable to archving data to GCS at '%s'.", (Object)gcsUrl);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    @Parameters(separators="=")
    public static final class Options
    implements CliOption {
        @Parameter(names={"--gcs-archiver-chunk-size-in-bytes"}, description="The size of the data chunk when GCS archiver uploads data to Cloud Storage.", validateWith=PositiveInteger.class)
        int chunkSizeInBytes = 1000;
        @Parameter(names={"--gcs-archiver-chunk-upload-threshold-in-bytes"}, description="The default data size threshold in bytes to enable chunk upload to GCS.", validateWith=PositiveInteger.class)
        int chunkUploadThresholdInBytes = 1000000;

        @Override
        public void validate() {
        }
    }

    public static interface Factory {
        public GoogleCloudStorageArchiver create(Storage var1);
    }
}

