/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.io.archiving;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.tsunami.common.io.archiving.Archiver;
import java.io.File;
import java.io.IOException;

public class RawFileArchiver
implements Archiver {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    @Override
    public boolean archive(String fileName, byte[] data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fileName) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)data);
        try {
            ((GoogleLogger.Api)logger.atInfo()).log("Archiving data to file system with filename '%s'.", (Object)fileName);
            Files.asByteSink((File)new File(fileName), (FileWriteMode[])new FileWriteMode[0]).write(data);
            return true;
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Failed archiving data to file '%s'.", (Object)fileName);
            return false;
        }
    }
}

