/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.tsunami.common.net.AutoValue_FuzzingUtils_HttpQueryParameter;
import com.google.tsunami.common.net.http.HttpRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public final class FuzzingUtils {
    public static ImmutableList<HttpRequest> fuzzGetParametersWithDefaultParameter(HttpRequest request, String payload, String defaultParameter) {
        return FuzzingUtils.fuzzGetParameters(request, payload, Optional.of(defaultParameter), (ImmutableSet<FuzzingModifier>)ImmutableSet.of());
    }

    public static ImmutableList<HttpRequest> fuzzGetParametersExpectingPathValues(HttpRequest request, String payload) {
        return FuzzingUtils.fuzzGetParameters(request, payload, Optional.empty(), (ImmutableSet<FuzzingModifier>)ImmutableSet.of((Object)((Object)FuzzingModifier.FUZZING_PATHS)));
    }

    public static ImmutableList<HttpRequest> fuzzGetParameters(HttpRequest request, String payload) {
        return FuzzingUtils.fuzzGetParameters(request, payload, Optional.empty(), (ImmutableSet<FuzzingModifier>)ImmutableSet.of());
    }

    private static ImmutableList<HttpRequest> fuzzGetParameters(HttpRequest request, String payload, Optional<String> defaultParameter, ImmutableSet<FuzzingModifier> modifiers) {
        URI parsedUrl = URI.create(request.url());
        ImmutableList<HttpQueryParameter> queryParams = FuzzingUtils.parseQuery(parsedUrl.getQuery());
        if (queryParams.isEmpty() && defaultParameter.isPresent()) {
            return ImmutableList.of((Object)request.toBuilder().setUrl(FuzzingUtils.assembleUrlWithQueries(parsedUrl, (ImmutableList<HttpQueryParameter>)ImmutableList.of((Object)HttpQueryParameter.create(defaultParameter.get(), payload)))).build());
        }
        return (ImmutableList)FuzzingUtils.fuzzParams(queryParams, payload, modifiers).stream().map(fuzzedParams -> FuzzingUtils.assembleUrlWithQueries(parsedUrl, (ImmutableList<HttpQueryParameter>)fuzzedParams)).map(fuzzedUrl -> request.toBuilder().setUrl((String)fuzzedUrl).build()).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<HttpQueryParameter> setFuzzedParams(ImmutableList<HttpQueryParameter> params, int index, String payload) {
        ArrayList<HttpQueryParameter> paramsWithPayload = new ArrayList<HttpQueryParameter>((Collection<HttpQueryParameter>)params);
        paramsWithPayload.set(index, HttpQueryParameter.create(((HttpQueryParameter)params.get(index)).name(), payload));
        return ImmutableList.copyOf(paramsWithPayload);
    }

    private static void fuzzParamsWithExtendedPathPayloads(ImmutableSet.Builder<ImmutableList<HttpQueryParameter>> builder, ImmutableList<HttpQueryParameter> params, int index, String payload) {
        int slashLocation;
        int dotLocation = ((HttpQueryParameter)params.get(index)).value().lastIndexOf(46);
        if (dotLocation != -1) {
            builder.add(FuzzingUtils.setFuzzedParams(params, index, payload + "%00" + ((HttpQueryParameter)params.get(index)).value().substring(dotLocation)));
        }
        if ((slashLocation = ((HttpQueryParameter)params.get(index)).value().lastIndexOf(47)) != -1) {
            builder.add(FuzzingUtils.setFuzzedParams(params, index, ((HttpQueryParameter)params.get(index)).value().substring(0, slashLocation + 1) + payload));
        }
        if (dotLocation != -1 && slashLocation != -1 && slashLocation < dotLocation) {
            builder.add(FuzzingUtils.setFuzzedParams(params, index, ((HttpQueryParameter)params.get(index)).value().substring(0, slashLocation + 1) + payload + "%00" + ((HttpQueryParameter)params.get(index)).value().substring(dotLocation)));
        }
    }

    private static ImmutableSet<ImmutableList<HttpQueryParameter>> fuzzParams(ImmutableList<HttpQueryParameter> params, String payload, ImmutableSet<FuzzingModifier> modifiers) {
        ImmutableSet.Builder fuzzedParamsBuilder = ImmutableSet.builder();
        for (int i = 0; i < params.size(); ++i) {
            fuzzedParamsBuilder.add(FuzzingUtils.setFuzzedParams(params, i, payload));
            if (!modifiers.contains((Object)FuzzingModifier.FUZZING_PATHS)) continue;
            FuzzingUtils.fuzzParamsWithExtendedPathPayloads((ImmutableSet.Builder<ImmutableList<HttpQueryParameter>>)fuzzedParamsBuilder, params, i, payload);
        }
        return fuzzedParamsBuilder.build();
    }

    public static ImmutableList<HttpQueryParameter> parseQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder queryParamsBuilder = ImmutableList.builder();
        for (String param : Splitter.on((char)'&').split((CharSequence)query)) {
            int equalPosition = param.indexOf("=");
            if (equalPosition > -1) {
                String name = param.substring(0, equalPosition);
                String value = param.substring(equalPosition + 1);
                queryParamsBuilder.add((Object)HttpQueryParameter.create(name, value));
                continue;
            }
            queryParamsBuilder.add((Object)HttpQueryParameter.create(param, ""));
        }
        return queryParamsBuilder.build();
    }

    private static String assembleUrlWithQueries(URI parsedUrl, ImmutableList<HttpQueryParameter> params) {
        String query = FuzzingUtils.assembleQueryParams(params);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(parsedUrl.getScheme()).append("://").append(parsedUrl.getRawAuthority());
        if (!Strings.isNullOrEmpty((String)parsedUrl.getRawPath())) {
            urlBuilder.append(parsedUrl.getRawPath());
        }
        if (!Strings.isNullOrEmpty((String)query)) {
            urlBuilder.append('?').append(query);
        }
        if (!Strings.isNullOrEmpty((String)parsedUrl.getRawFragment())) {
            urlBuilder.append('#').append(parsedUrl.getRawFragment());
        }
        return urlBuilder.toString();
    }

    private static String assembleQueryParams(ImmutableList<HttpQueryParameter> params) {
        return params.stream().map(param -> String.format("%s=%s", param.name(), param.value())).collect(Collectors.joining("&"));
    }

    private FuzzingUtils() {
    }

    static enum FuzzingModifier {
        FUZZING_PATHS;

    }

    @AutoValue
    public static abstract class HttpQueryParameter {
        public abstract String name();

        public abstract String value();

        public static HttpQueryParameter create(String name, String value) {
            return new AutoValue_FuzzingUtils_HttpQueryParameter(name, value);
        }
    }
}

