/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.AutoValue_HttpRequest;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpMethod;
import java.util.Optional;
import okhttp3.HttpUrl;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class HttpRequest {
    public abstract HttpMethod method();

    public abstract String url();

    public abstract HttpHeaders headers();

    public abstract Optional<ByteString> requestBody();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_HttpRequest.Builder();
    }

    public static Builder get(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return HttpRequest.builder().setMethod(HttpMethod.GET).setUrl(url);
    }

    public static Builder get(HttpUrl uri) {
        Preconditions.checkNotNull((Object)uri);
        return HttpRequest.builder().setMethod(HttpMethod.GET).setUrl(uri);
    }

    public static Builder head(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return HttpRequest.builder().setMethod(HttpMethod.HEAD).setUrl(url);
    }

    public static Builder head(HttpUrl uri) {
        Preconditions.checkNotNull((Object)uri);
        return HttpRequest.builder().setMethod(HttpMethod.HEAD).setUrl(uri);
    }

    public static Builder post(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return HttpRequest.builder().setMethod(HttpMethod.POST).setUrl(url);
    }

    public static Builder post(HttpUrl uri) {
        Preconditions.checkNotNull((Object)uri);
        return HttpRequest.builder().setMethod(HttpMethod.POST).setUrl(uri);
    }

    public static Builder put(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return HttpRequest.put(HttpUrl.parse((String)url));
    }

    public static Builder put(HttpUrl uri) {
        Preconditions.checkNotNull((Object)uri);
        return HttpRequest.builder().setMethod(HttpMethod.PUT).setUrl(uri);
    }

    public static Builder delete(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return HttpRequest.builder().setMethod(HttpMethod.DELETE).setUrl(url);
    }

    public static Builder delete(HttpUrl uri) {
        Preconditions.checkNotNull((Object)uri);
        return HttpRequest.builder().setMethod(HttpMethod.DELETE).setUrl(uri);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMethod(HttpMethod var1);

        public abstract Builder setUrl(String var1);

        public Builder setUrl(HttpUrl url) {
            this.setUrl(url.toString());
            return this;
        }

        public abstract Builder setHeaders(HttpHeaders var1);

        public abstract Builder setRequestBody(ByteString var1);

        public abstract Builder setRequestBody(Optional<ByteString> var1);

        public Builder withEmptyHeaders() {
            this.setHeaders(HttpHeaders.builder().build());
            return this;
        }

        abstract HttpRequest autoBuild();

        public HttpRequest build() {
            HttpRequest httpRequest = this.autoBuild();
            switch (httpRequest.method()) {
                case GET: 
                case HEAD: {
                    Preconditions.checkState((!httpRequest.requestBody().isPresent() ? 1 : 0) != 0, (Object)"A request body is not allowed for HTTP GET/HEAD request");
                    break;
                }
            }
            return httpRequest;
        }
    }
}

