/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.function.Function;

public enum HttpStatus {
    HTTP_STATUS_UNSPECIFIED(0, "Status Unspecified"),
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    OK(200, "Ok"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MULTI_STATUS(207, "Multi-Status"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LONG(414, "Request Uri Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUEST_RANGE_NOT_SATISFIABLE(416, "Request Range Not Satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    PRECONDITION_REQUIRED(428, "Precondition Required"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    HTTP_VERSION_NOT_SUPPORTED(505, "Http Version Not Supported"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required"),
    QUIRK_IE_NO_CONTENT(1223, "Quirk IE No Content");

    private static final ImmutableMap<Integer, HttpStatus> BY_CODE;
    private final int code;
    private final String name;

    public static HttpStatus fromCode(int code) {
        HttpStatus status = (HttpStatus)((Object)BY_CODE.get((Object)code));
        return status == null ? HTTP_STATUS_UNSPECIFIED : status;
    }

    private HttpStatus(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int code() {
        return this.code;
    }

    public boolean isRedirect() {
        switch (this) {
            case MULTIPLE_CHOICES: 
            case MOVED_PERMANENTLY: 
            case FOUND: 
            case SEE_OTHER: 
            case TEMPORARY_REDIRECT: 
            case PERMANENT_REDIRECT: {
                return true;
            }
        }
        return false;
    }

    public boolean isSuccess() {
        return this.code >= 200 && this.code < 300;
    }

    public String toString() {
        return this.name;
    }

    static {
        BY_CODE = (ImmutableMap)Arrays.stream(HttpStatus.values()).collect(ImmutableMap.toImmutableMap(HttpStatus::code, Function.identity()));
    }
}

