/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.HttpClient;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpMethod;
import com.google.tsunami.common.net.http.HttpRequest;
import com.google.tsunami.common.net.http.HttpResponse;
import com.google.tsunami.common.net.http.HttpStatus;
import com.google.tsunami.common.net.http.javanet.ConnectionFactory;
import com.google.tsunami.proto.NetworkService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

final class OkHttpHttpClient
extends HttpClient {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final OkHttpClient okHttpClient;
    private final boolean trustAllCertificates;
    private final ConnectionFactory connectionFactory;
    private final String logId;
    private final Duration connectionTimeout;
    private final String userAgent;

    OkHttpHttpClient(OkHttpClient okHttpClient, boolean trustAllCertificates, ConnectionFactory connectionFactory, String logId, Duration connectionTimeout, String userAgent) {
        this.okHttpClient = (OkHttpClient)Preconditions.checkNotNull((Object)okHttpClient);
        this.trustAllCertificates = trustAllCertificates;
        this.connectionFactory = (ConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
        this.logId = logId;
        this.connectionTimeout = connectionTimeout;
        this.userAgent = Strings.isNullOrEmpty((String)userAgent) ? "TsunamiSecurityScanner" : userAgent;
    }

    @Override
    public String getLogId() {
        return this.logId;
    }

    @Override
    public HttpResponse sendAsIs(HttpRequest httpRequest) throws IOException {
        HttpURLConnection connection = this.connectionFactory.openConnection(httpRequest.url());
        connection.setRequestMethod(httpRequest.method().toString());
        httpRequest.headers().names().stream().filter(headerName -> !Ascii.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")).forEach(headerName -> httpRequest.headers().getAll((String)headerName).forEach(headerValue -> connection.setRequestProperty((String)headerName, (String)headerValue)));
        connection.setRequestProperty("User-Agent", this.userAgent);
        if (ImmutableSet.of((Object)((Object)HttpMethod.POST), (Object)((Object)HttpMethod.PUT), (Object)((Object)HttpMethod.DELETE)).contains((Object)httpRequest.method())) {
            connection.setDoOutput(true);
            ByteSource.wrap((byte[])httpRequest.requestBody().orElse(ByteString.EMPTY).toByteArray()).copyTo(connection.getOutputStream());
        }
        int responseCode = connection.getResponseCode();
        HttpHeaders.Builder responseHeadersBuilder = HttpHeaders.builder();
        for (Map.Entry<String, List<String>> headerEntry : connection.getHeaderFields().entrySet()) {
            String headerName2 = headerEntry.getKey();
            if (Strings.isNullOrEmpty((String)headerName2)) continue;
            for (String headerValue : headerEntry.getValue()) {
                if (Strings.isNullOrEmpty((String)headerValue)) continue;
                responseHeadersBuilder.addHeader(headerName2, headerValue);
            }
        }
        return HttpResponse.builder().setStatus(HttpStatus.fromCode(responseCode)).setHeaders(responseHeadersBuilder.build()).setBodyBytes(ByteString.readFrom((InputStream)connection.getInputStream())).build();
    }

    @Override
    public HttpResponse send(HttpRequest httpRequest) throws IOException {
        return this.send(httpRequest, null);
    }

    @Override
    public HttpResponse send(HttpRequest httpRequest, @Nullable NetworkService networkService) throws IOException {
        ((GoogleLogger.Api)logger.atInfo()).log("%sSending HTTP '%s' request to '%s'.", (Object)this.logId, (Object)httpRequest.method(), (Object)httpRequest.url());
        OkHttpClient callHttpClient = this.clientWithHostnameAsProxy(networkService);
        try (Response okHttpResponse = callHttpClient.newCall(OkHttpHttpClient.buildOkHttpRequest(httpRequest, this.userAgent)).execute();){
            HttpResponse httpResponse = OkHttpHttpClient.parseResponse(okHttpResponse);
            return httpResponse;
        }
    }

    @Override
    public ListenableFuture<HttpResponse> sendAsync(HttpRequest httpRequest) {
        return this.sendAsync(httpRequest, null);
    }

    @Override
    public ListenableFuture<HttpResponse> sendAsync(HttpRequest httpRequest, @Nullable NetworkService networkService) {
        ((GoogleLogger.Api)logger.atInfo()).log("%sSending async HTTP '%s' request to '%s'.", (Object)this.logId, (Object)httpRequest.method(), (Object)httpRequest.url());
        OkHttpClient callHttpClient = this.clientWithHostnameAsProxy(networkService);
        final SettableFuture responseFuture = SettableFuture.create();
        Call requestCall = callHttpClient.newCall(OkHttpHttpClient.buildOkHttpRequest(httpRequest, this.userAgent));
        try {
            requestCall.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    responseFuture.setException((Throwable)e);
                }

                public void onResponse(Call call, Response response) {
                    try (ResponseBody unused = response.body();){
                        responseFuture.set((Object)OkHttpHttpClient.parseResponse(response));
                    }
                    catch (Throwable t) {
                        responseFuture.setException(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            responseFuture.setException(t);
        }
        responseFuture.addListener(() -> {
            if (responseFuture.isCancelled()) {
                requestCall.cancel();
            }
        }, MoreExecutors.directExecutor());
        return responseFuture;
    }

    private OkHttpClient clientWithHostnameAsProxy(NetworkService networkService) {
        if (networkService == null) {
            return this.okHttpClient;
        }
        String serviceIp = networkService.getNetworkEndpoint().getIpAddress().getAddress();
        String serviceHostname = networkService.getNetworkEndpoint().getHostname().getName();
        return this.okHttpClient.newBuilder().dns(hostname -> {
            if (hostname.equals(serviceHostname)) {
                hostname = serviceIp;
            }
            return Dns.SYSTEM.lookup(hostname);
        }).hostnameVerifier((hostname, session) -> {
            if (this.trustAllCertificates) {
                return true;
            }
            if (hostname.equals(serviceHostname)) {
                return true;
            }
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }).build();
    }

    private static Request buildOkHttpRequest(HttpRequest httpRequest, String userAgent) {
        Request.Builder okRequestBuilder = new Request.Builder().url(httpRequest.url());
        httpRequest.headers().names().stream().filter(headerName -> !Ascii.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")).forEach(headerName -> httpRequest.headers().getAll((String)headerName).forEach(headerValue -> okRequestBuilder.addHeader(headerName, headerValue)));
        okRequestBuilder.addHeader("User-Agent", userAgent);
        switch (httpRequest.method()) {
            case GET: {
                okRequestBuilder.get();
                break;
            }
            case HEAD: {
                okRequestBuilder.head();
                break;
            }
            case PUT: {
                okRequestBuilder.put(OkHttpHttpClient.buildRequestBody(httpRequest));
                break;
            }
            case POST: {
                okRequestBuilder.post(OkHttpHttpClient.buildRequestBody(httpRequest));
                break;
            }
            case DELETE: {
                okRequestBuilder.delete(OkHttpHttpClient.buildRequestBody(httpRequest));
            }
        }
        return okRequestBuilder.build();
    }

    private static RequestBody buildRequestBody(HttpRequest httpRequest) {
        MediaType mediaType = MediaType.parse((String)httpRequest.headers().get("Content-Type").orElse(""));
        return RequestBody.create((MediaType)mediaType, (byte[])httpRequest.requestBody().orElse(ByteString.EMPTY).toByteArray());
    }

    private static HttpResponse parseResponse(Response okResponse) throws IOException {
        ((GoogleLogger.Api)logger.atInfo()).log("Received HTTP response with code '%d' for request to '%s'.", okResponse.code(), (Object)okResponse.request().url());
        HttpResponse.Builder httpResponseBuilder = HttpResponse.builder().setStatus(HttpStatus.fromCode(okResponse.code())).setHeaders(OkHttpHttpClient.convertHeaders(okResponse.headers())).setResponseUrl(okResponse.request().url());
        if (!okResponse.request().method().equals(HttpMethod.HEAD.name()) && okResponse.body() != null) {
            httpResponseBuilder.setBodyBytes(ByteString.copyFrom((byte[])okResponse.body().bytes()));
        }
        return httpResponseBuilder.build();
    }

    private static HttpHeaders convertHeaders(Headers headers) {
        HttpHeaders.Builder headersBuilder = HttpHeaders.builder();
        for (int i = 0; i < headers.size(); ++i) {
            headersBuilder.addHeader(headers.name(i), headers.value(i));
        }
        return headersBuilder.build();
    }

    public HttpClient.Builder<OkHttpHttpClient> modify() {
        return new OkHttpHttpClientBuilder(this);
    }

    public static class OkHttpHttpClientBuilder
    extends HttpClient.Builder<OkHttpHttpClient> {
        private final OkHttpClient okHttpClient;
        private boolean followRedirects;
        private boolean trustAllCertificates;
        private final ConnectionFactory connectionFactory;
        private String logId;
        private Duration connectionTimeout;
        private String userAgent;

        private OkHttpHttpClientBuilder(OkHttpHttpClient okHttpHttpClient) {
            this.okHttpClient = okHttpHttpClient.okHttpClient;
            this.followRedirects = this.okHttpClient.followRedirects();
            this.trustAllCertificates = okHttpHttpClient.trustAllCertificates;
            this.connectionFactory = okHttpHttpClient.connectionFactory;
            this.logId = okHttpHttpClient.logId;
            this.connectionTimeout = okHttpHttpClient.connectionTimeout;
            this.userAgent = okHttpHttpClient.userAgent;
        }

        public OkHttpHttpClientBuilder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public OkHttpHttpClientBuilder setLogId(String logId) {
            this.logId = logId;
            return this;
        }

        public OkHttpHttpClientBuilder setConnectTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @CanIgnoreReturnValue
        public OkHttpHttpClientBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public OkHttpHttpClient build() {
            return new OkHttpHttpClient(this.okHttpClient.newBuilder().followRedirects(this.followRedirects).build(), this.trustAllCertificates, this.connectionFactory, this.logId, this.connectionTimeout, this.userAgent);
        }
    }
}

