/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.server;

import com.google.common.collect.ImmutableList;
import com.google.tsunami.proto.MatchedPlugin;
import com.google.tsunami.proto.NetworkService;
import com.google.tsunami.proto.PluginDefinition;
import com.google.tsunami.proto.RunCompactRequest;
import com.google.tsunami.proto.RunRequest;
import java.util.HashMap;

public final class CompactRunRequestHelper {
    private CompactRunRequestHelper() {
    }

    public static RunCompactRequest compress(RunRequest runRequest) {
        RunCompactRequest.Builder builder = RunCompactRequest.newBuilder().setTarget(runRequest.getTarget());
        HashMap<NetworkService, Integer> serviceIndexMap = new HashMap<NetworkService, Integer>();
        int pluginIndex = -1;
        for (MatchedPlugin matchedPlugin : runRequest.getPluginsList()) {
            ++pluginIndex;
            builder.addPlugins(matchedPlugin.getPlugin());
            for (NetworkService service : matchedPlugin.getServicesList()) {
                Integer serviceIndex = (Integer)serviceIndexMap.get(service);
                if (serviceIndex == null) {
                    serviceIndex = serviceIndexMap.size();
                    serviceIndexMap.put(service, serviceIndex);
                    builder.addServices(service);
                }
                builder.addScanTargets(RunCompactRequest.PluginNetworkServiceTarget.newBuilder().setPluginIndex(pluginIndex).setServiceIndex(serviceIndex.intValue()).build());
            }
        }
        return builder.build();
    }

    public static RunRequest uncompress(RunCompactRequest runCompactRequest) {
        ImmutableList.Builder matchedPlugins = ImmutableList.builder();
        for (RunCompactRequest.PluginNetworkServiceTarget target : runCompactRequest.getScanTargetsList()) {
            PluginDefinition plugin = runCompactRequest.getPlugins(target.getPluginIndex());
            NetworkService networkService = runCompactRequest.getServices(target.getServiceIndex());
            matchedPlugins.add((Object)MatchedPlugin.newBuilder().setPlugin(plugin).addServices(networkService).build());
        }
        return RunRequest.newBuilder().setTarget(runCompactRequest.getTarget()).addAllPlugins((Iterable)matchedPlugins.build()).build();
    }
}

