/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.time.testing;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.atomic.AtomicReference;

public final class FakeUtcClock
extends Clock {
    private final AtomicReference<Instant> nowReference = new AtomicReference();

    private FakeUtcClock(Instant now) {
        this.nowReference.set((Instant)Preconditions.checkNotNull((Object)now));
    }

    public static FakeUtcClock create() {
        return new FakeUtcClock(Instant.now());
    }

    public FakeUtcClock setNow(Instant now) {
        this.nowReference.set((Instant)Preconditions.checkNotNull((Object)now));
        return this;
    }

    public FakeUtcClock advance(Duration increment) {
        Preconditions.checkNotNull((Object)increment);
        this.nowReference.getAndUpdate(now -> now.plus(increment));
        return this;
    }

    @Override
    public Instant instant() {
        return this.nowReference.get();
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new UnsupportedOperationException("Setting ZoneId to FakeUtcClock is not supported");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FakeUtcClock) {
            FakeUtcClock other = (FakeUtcClock)obj;
            return this.nowReference.get().equals(other.nowReference.get());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.nowReference.get().hashCode();
    }

    public String toString() {
        return String.format("FakeUtcClock(now = %s)", this.nowReference.get());
    }
}

