/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import java.util.Arrays;

enum KnownQualifier implements Comparable<KnownQualifier>
{
    ALPHA("alpha"),
    BETA("beta"),
    PRE("pre"),
    R("r"),
    RC("rc"),
    ABSENT(""),
    P("p"),
    PATCH("patch"),
    PATCHED("patched");

    private final String qualifierText;

    private KnownQualifier(String qualifierText) {
        this.qualifierText = qualifierText;
    }

    String getQualifierText() {
        return this.qualifierText;
    }

    static boolean isKnownQualifier(String string) {
        Preconditions.checkNotNull((Object)string);
        return Arrays.stream(KnownQualifier.values()).anyMatch(knownQualifier -> Ascii.equalsIgnoreCase((CharSequence)knownQualifier.qualifierText, (CharSequence)string));
    }

    static KnownQualifier fromText(String string) {
        Preconditions.checkNotNull((Object)string);
        return Arrays.stream(KnownQualifier.values()).filter(knownQualifier -> Ascii.equalsIgnoreCase((CharSequence)knownQualifier.qualifierText, (CharSequence)string)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a valid KnownQualifier text.", string)));
    }
}

