/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.version.AutoValue_Segment;
import com.google.tsunami.common.version.ComparisonUtility;
import com.google.tsunami.common.version.KnownQualifier;
import com.google.tsunami.common.version.Token;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Immutable
@AutoValue
abstract class Segment
implements Comparable<Segment> {
    static final Segment NULL = Segment.fromTokenList((ImmutableList<Token>)ImmutableList.of((Object)Token.EMPTY));
    private static final ImmutableSet<String> TOKENIZER_DELIMITERS = ImmutableSet.of((Object)"\\.", (Object)"\\+", (Object)"-", (Object)":", (Object)"_", (Object)"~", (Object[])new String[0]);
    private static final Pattern TOKENIZER_SPLIT_REGEX = Pattern.compile("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)|" + TOKENIZER_DELIMITERS.stream().map(delimiter -> String.format("((?<=%1$s)|(?=%1$s))", delimiter)).collect(Collectors.joining("|")));
    private static final ImmutableSet<String> EXCLUDED_TOKENS = ImmutableSet.of((Object)".", (Object)"gg", (Object)"N/A");

    Segment() {
    }

    abstract ImmutableList<Token> tokens();

    static Segment fromTokenList(ImmutableList<Token> tokens) {
        ImmutableList.Builder finalTokensBuilder = new ImmutableList.Builder();
        if (tokens.isEmpty() || !((Token)tokens.get(0)).isKnownQualifier()) {
            finalTokensBuilder.add((Object)Token.fromKnownQualifier(KnownQualifier.ABSENT));
        }
        finalTokensBuilder.addAll(tokens);
        return new AutoValue_Segment((ImmutableList<Token>)finalTokensBuilder.build());
    }

    static Segment fromString(String segmentString) {
        return Segment.parseFromString(segmentString);
    }

    private static Segment parseFromString(String segmentString) {
        ImmutableList rawTokens = (ImmutableList)Arrays.stream(TOKENIZER_SPLIT_REGEX.split(segmentString)).filter(token -> !token.isEmpty()).filter(token -> !EXCLUDED_TOKENS.contains(token)).collect(ImmutableList.toImmutableList());
        if (rawTokens.isEmpty()) {
            return NULL;
        }
        ImmutableList.Builder tokensBuilder = new ImmutableList.Builder();
        if (!KnownQualifier.isKnownQualifier((String)rawTokens.get(0))) {
            tokensBuilder.add((Object)Token.fromKnownQualifier(KnownQualifier.ABSENT));
        }
        for (String rawToken : rawTokens) {
            try {
                long numericToken = Long.parseLong(rawToken);
                tokensBuilder.add((Object)Token.fromNumeric(numericToken));
            }
            catch (NumberFormatException e) {
                tokensBuilder.add((Object)Token.fromText(rawToken));
            }
        }
        return Segment.fromTokenList((ImmutableList<Token>)tokensBuilder.build());
    }

    @Override
    public int compareTo(Segment other) {
        return ComparisonUtility.compareListWithFillValue(this.tokens(), other.tokens(), Token.EMPTY);
    }
}

