/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.auto.value.AutoOneOf;
import com.google.common.base.Ascii;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.version.AutoOneOf_Token;
import com.google.tsunami.common.version.KnownQualifier;

@Immutable
@AutoOneOf(value=Kind.class)
abstract class Token
implements Comparable<Token> {
    static final Token EMPTY = Token.fromKnownQualifier(KnownQualifier.ABSENT);

    Token() {
    }

    abstract Kind getKind();

    abstract long getNumeric();

    static Token fromNumeric(long numeric) {
        return AutoOneOf_Token.numeric(numeric);
    }

    boolean isNumeric() {
        return this.getKind().equals((Object)Kind.NUMERIC);
    }

    abstract String getText();

    static Token fromText(String string) {
        return AutoOneOf_Token.text(Ascii.toLowerCase((String)string));
    }

    boolean isText() {
        return this.getKind().equals((Object)Kind.TEXT);
    }

    static Token fromKnownQualifier(KnownQualifier knownQualifier) {
        return AutoOneOf_Token.text(knownQualifier.getQualifierText());
    }

    boolean isKnownQualifier() {
        return this.isText() && KnownQualifier.isKnownQualifier(this.getText());
    }

    boolean isEmptyToken() {
        return this.isText() && this.getText().isEmpty();
    }

    @Override
    public int compareTo(Token other) {
        if (this.isEmptyToken() && other.isEmptyToken()) {
            return 0;
        }
        if (this.isEmptyToken() && other.isNumeric()) {
            return -1;
        }
        if (this.isNumeric() && other.isEmptyToken()) {
            return 1;
        }
        if (this.isNumeric() && other.isNumeric()) {
            return Long.compare(this.getNumeric(), other.getNumeric());
        }
        if (this.isKnownQualifier() && other.isKnownQualifier()) {
            return KnownQualifier.fromText(this.getText()).compareTo(KnownQualifier.fromText(other.getText()));
        }
        if (this.isText() && other.isText()) {
            return this.getText().compareToIgnoreCase(other.getText());
        }
        return this.getKind().compareTo(other.getKind());
    }

    public static enum Kind {
        NUMERIC,
        TEXT;

    }
}

