/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.version.AutoValue_VersionRange;
import com.google.tsunami.common.version.Version;

@Immutable
@AutoValue
public abstract class VersionRange {
    public abstract Version minVersion();

    public abstract Inclusiveness minVersionInclusiveness();

    public abstract Version maxVersion();

    public abstract Inclusiveness maxVersionInclusiveness();

    public static Builder builder() {
        return new AutoValue_VersionRange.Builder();
    }

    public static VersionRange parse(String rangeString) {
        Version maxVersion;
        Version minVersion;
        VersionRange.validateRangeString(rangeString);
        Inclusiveness minVersionInclusiveness = rangeString.startsWith("[") ? Inclusiveness.INCLUSIVE : Inclusiveness.EXCLUSIVE;
        Inclusiveness maxVersionInclusiveness = rangeString.endsWith("]") ? Inclusiveness.INCLUSIVE : Inclusiveness.EXCLUSIVE;
        int commaIndex = rangeString.indexOf(44);
        String minVersionString = rangeString.substring(1, commaIndex).trim();
        if (minVersionString.isEmpty()) {
            minVersionInclusiveness = Inclusiveness.EXCLUSIVE;
            minVersion = Version.minimum();
        } else {
            minVersion = Version.fromString(minVersionString);
        }
        String maxVersionString = rangeString.substring(commaIndex + 1, rangeString.length() - 1).trim();
        if (maxVersionString.isEmpty()) {
            maxVersionInclusiveness = Inclusiveness.EXCLUSIVE;
            maxVersion = Version.maximum();
        } else {
            maxVersion = Version.fromString(maxVersionString);
        }
        if (!minVersion.isLessThan(maxVersion)) {
            throw new IllegalArgumentException(String.format("Min version in range must be less than max version in range, got '%s'", rangeString));
        }
        return VersionRange.builder().setMinVersion(minVersion).setMinVersionInclusiveness(minVersionInclusiveness).setMaxVersion(maxVersion).setMaxVersionInclusiveness(maxVersionInclusiveness).build();
    }

    public static boolean isValidVersionRange(String rangeString) {
        try {
            VersionRange.parse(rangeString);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void validateRangeString(String rangeString) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)rangeString) ? 1 : 0) != 0, (Object)"Range string cannot be empty.");
        if (!rangeString.startsWith("[") && !rangeString.startsWith("(")) {
            throw new IllegalArgumentException(String.format("Version range must start with '[' or '(', got '%s'", rangeString));
        }
        if (!rangeString.endsWith("]") && !rangeString.endsWith(")")) {
            throw new IllegalArgumentException(String.format("Version range must end with ']' or ')', got '%s'", rangeString));
        }
        String trimmedRange = rangeString.substring(1, rangeString.length() - 1).trim();
        if (CharMatcher.anyOf((CharSequence)"[()]").matchesAnyOf((CharSequence)trimmedRange)) {
            throw new IllegalArgumentException(String.format("Parenthesis and/or brackets not allowed within version range, got '%s'", rangeString));
        }
        if (CharMatcher.is((char)',').countIn((CharSequence)trimmedRange) != 1) {
            throw new IllegalArgumentException(String.format("Invalid range of versions, got '%s'", rangeString));
        }
        if (trimmedRange.equals(",")) {
            throw new IllegalArgumentException(String.format("Infinity range is not supported, got '%s'", rangeString));
        }
    }

    public static enum Inclusiveness {
        INCLUSIVE,
        EXCLUSIVE;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMinVersion(Version var1);

        public abstract Builder setMinVersionInclusiveness(Inclusiveness var1);

        public abstract Builder setMaxVersion(Version var1);

        public abstract Builder setMaxVersionInclusiveness(Inclusiveness var1);

        public abstract VersionRange build();
    }
}

