/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.version.AutoValue_VersionSet;
import com.google.tsunami.common.version.Version;
import com.google.tsunami.common.version.VersionRange;

@Immutable
@AutoValue
public abstract class VersionSet {
    public abstract ImmutableList<Version> versions();

    public abstract ImmutableList<VersionRange> versionRanges();

    public static Builder builder() {
        return new AutoValue_VersionSet.Builder();
    }

    public static VersionSet parse(ImmutableList<String> versionAndRangesList) {
        Preconditions.checkNotNull(versionAndRangesList);
        Preconditions.checkArgument((!versionAndRangesList.isEmpty() ? 1 : 0) != 0, (Object)"Versions and ranges list cannot be empty.");
        Builder versionSetBuilder = VersionSet.builder();
        for (String versionOrRangeString : versionAndRangesList) {
            if (VersionSet.isDiscreteVersion(versionOrRangeString)) {
                versionSetBuilder.addVersion(Version.fromString(versionOrRangeString));
                continue;
            }
            if (VersionRange.isValidVersionRange(versionOrRangeString)) {
                versionSetBuilder.addVersionRange(VersionRange.parse(versionOrRangeString));
                continue;
            }
            throw new IllegalArgumentException(String.format("String '%s' is neither a discrete string nor a version range.", versionOrRangeString));
        }
        return versionSetBuilder.build();
    }

    private static boolean isDiscreteVersion(String versionOrRangeString) {
        return CharMatcher.anyOf((CharSequence)"[()], ").matchesNoneOf((CharSequence)versionOrRangeString);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableList.Builder<Version> versionsBuilder();

        public Builder addVersion(Version version) {
            this.versionsBuilder().add((Object)version);
            return this;
        }

        abstract ImmutableList.Builder<VersionRange> versionRangesBuilder();

        public Builder addVersionRange(VersionRange versionRange) {
            this.versionRangesBuilder().add((Object)versionRange);
            return this;
        }

        public abstract VersionSet build();
    }
}

