/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.tsunami.common.cli.CliOption;
import com.google.tsunami.common.io.archiving.Archiver;
import com.google.tsunami.common.io.archiving.GoogleCloudStorageArchiver;
import com.google.tsunami.common.io.archiving.RawFileArchiver;
import com.google.tsunami.main.cli.option.OutputDataFormat;
import com.google.tsunami.proto.ScanResults;
import javax.inject.Inject;

class ScanResultsArchiver {
    private final Options options;
    private final RawFileArchiver rawFileArchiver;
    private final GoogleCloudStorageArchiver.Factory googleCloudStorageArchiverFactory;

    @Inject
    ScanResultsArchiver(Options options, RawFileArchiver rawFileArchiver, GoogleCloudStorageArchiver.Factory googleCloudStorageArchiverFactory) {
        this.options = (Options)Preconditions.checkNotNull((Object)options);
        this.rawFileArchiver = (RawFileArchiver)Preconditions.checkNotNull((Object)rawFileArchiver);
        this.googleCloudStorageArchiverFactory = (GoogleCloudStorageArchiver.Factory)Preconditions.checkNotNull((Object)googleCloudStorageArchiverFactory);
    }

    Storage getGcsStorage() {
        return (Storage)StorageOptions.getDefaultInstance().getService();
    }

    void archive(ScanResults scanResults) throws InvalidProtocolBufferException {
        if (!Strings.isNullOrEmpty((String)this.options.localOutputFilename)) {
            ScanResultsArchiver.archive((Archiver)this.rawFileArchiver, this.options.localOutputFilename, this.options.localOutputFormat, scanResults);
        }
        if (!Strings.isNullOrEmpty((String)this.options.gcsOutputFileUrl)) {
            GoogleCloudStorageArchiver archiver = this.googleCloudStorageArchiverFactory.create(this.getGcsStorage());
            ScanResultsArchiver.archive((Archiver)archiver, this.options.gcsOutputFileUrl, this.options.gcsOutputFormat, scanResults);
        }
    }

    private static void archive(Archiver archiver, String location, OutputDataFormat outputFormat, ScanResults scanResults) throws InvalidProtocolBufferException {
        switch (outputFormat) {
            case BIN_PROTO: {
                archiver.archive(location, scanResults.toByteArray());
                break;
            }
            case JSON: {
                archiver.archive(location, (CharSequence)JsonFormat.printer().print((MessageOrBuilder)scanResults));
            }
        }
    }

    @Parameters(separators="=")
    static final class Options
    implements CliOption {
        @Parameter(names={"--scan-results-local-output-filename"}, description="The local output filename of the scanning results.")
        public String localOutputFilename;
        @Parameter(names={"--scan-results-local-output-format"}, description="The format of the scanning results saved as local file.")
        public OutputDataFormat localOutputFormat;
        @Parameter(names={"--scan-results-gcs-output-file-url"}, description="The GCS file url for the uploaded scanning results.")
        public String gcsOutputFileUrl;
        @Parameter(names={"--scan-results-gcs-output-format"}, description="The format of the scanning results uploaded to GCS bucket.")
        public OutputDataFormat gcsOutputFormat;

        Options() {
        }

        public void validate() {
            if (!Strings.isNullOrEmpty((String)this.gcsOutputFileUrl) && !GoogleCloudStorageArchiver.GS_URL_PATTERN.matcher(this.gcsOutputFileUrl).matches()) {
                throw new ParameterException(String.format("Malformed GCS URL: '%s'", this.gcsOutputFileUrl));
            }
        }
    }
}

