/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.tsunami.common.cli.CliOptionsModule;
import com.google.tsunami.common.command.CommandExecutorModule;
import com.google.tsunami.common.config.ConfigLoader;
import com.google.tsunami.common.config.ConfigModule;
import com.google.tsunami.common.config.TsunamiConfig;
import com.google.tsunami.common.config.YamlConfigLoader;
import com.google.tsunami.common.data.NetworkEndpointUtils;
import com.google.tsunami.common.data.NetworkServiceUtils;
import com.google.tsunami.common.io.archiving.GoogleCloudStorageArchiverModule;
import com.google.tsunami.common.net.http.HttpClientModule;
import com.google.tsunami.common.reflection.ClassGraphModule;
import com.google.tsunami.common.time.SystemUtcClockModule;
import com.google.tsunami.main.cli.ScanResultsArchiver;
import com.google.tsunami.main.cli.ScanResultsArchiverModule;
import com.google.tsunami.main.cli.option.MainCliOptions;
import com.google.tsunami.plugin.PluginExecutionModule;
import com.google.tsunami.plugin.PluginLoadingModule;
import com.google.tsunami.plugin.payload.PayloadGeneratorModule;
import com.google.tsunami.proto.ScanResults;
import com.google.tsunami.proto.ScanStatus;
import com.google.tsunami.proto.ScanTarget;
import com.google.tsunami.workflow.DefaultScanningWorkflow;
import com.google.tsunami.workflow.ScanningWorkflowException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;

public final class TsunamiCli {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final DefaultScanningWorkflow scanningWorkflow;
    private final ScanResultsArchiver scanResultsArchiver;
    private final MainCliOptions mainCliOptions;

    @Inject
    TsunamiCli(DefaultScanningWorkflow scanningWorkflow, ScanResultsArchiver scanResultsArchiver, MainCliOptions mainCliOptions) {
        this.scanningWorkflow = (DefaultScanningWorkflow)Preconditions.checkNotNull((Object)scanningWorkflow);
        this.scanResultsArchiver = (ScanResultsArchiver)Preconditions.checkNotNull((Object)scanResultsArchiver);
        this.mainCliOptions = (MainCliOptions)Preconditions.checkNotNull((Object)mainCliOptions);
    }

    public boolean run() throws ExecutionException, InterruptedException, ScanningWorkflowException, IOException {
        String logId = this.mainCliOptions.logId == null ? "" : this.mainCliOptions.logId + ": ";
        ((GoogleLogger.Api)logger.atInfo()).log("%sTsunamiCli starting...", (Object)logId);
        ScanResults scanResults = this.scanningWorkflow.run(this.buildScanTarget());
        ((GoogleLogger.Api)logger.atInfo()).log("Tsunami scan finished, saving results.");
        this.saveResults(scanResults);
        if (TsunamiCli.hasSuccessfulResults(scanResults)) {
            ((GoogleLogger.Api)logger.atInfo()).log("TsunamiCli finished...");
            return true;
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Tsunami scan has failed status, message = %s.", (Object)scanResults.getStatusMessage());
        return false;
    }

    private static boolean hasSuccessfulResults(ScanResults scanResults) {
        return scanResults.getScanStatus().equals((Object)ScanStatus.SUCCEEDED) || scanResults.getScanStatus().equals((Object)ScanStatus.PARTIALLY_SUCCEEDED);
    }

    private ScanTarget buildScanTarget() {
        ScanTarget.Builder scanTargetBuilder = ScanTarget.newBuilder();
        String ip = null;
        if (this.mainCliOptions.ipV4Target != null) {
            ip = this.mainCliOptions.ipV4Target;
        } else if (this.mainCliOptions.ipV6Target != null) {
            ip = this.mainCliOptions.ipV6Target;
        }
        if (ip != null && this.mainCliOptions.hostnameTarget != null) {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forIpAndHostname((String)ip, (String)this.mainCliOptions.hostnameTarget));
        } else if (ip != null) {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forIp((String)ip));
        } else if (this.mainCliOptions.uriTarget != null) {
            scanTargetBuilder.setNetworkService(NetworkServiceUtils.buildUriNetworkService((String)this.mainCliOptions.uriTarget));
        } else {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forHostname((String)this.mainCliOptions.hostnameTarget));
        }
        return scanTargetBuilder.build();
    }

    private void saveResults(ScanResults scanResults) throws IOException {
        this.scanResultsArchiver.archive(scanResults);
    }

    public static void main(String[] args) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        TsunamiConfig tsunamiConfig = TsunamiCli.loadConfig();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().blacklistPackages(new String[]{"com.google.tsunami.plugin.testing"}).scan();){
            ((GoogleLogger.Api)logger.atInfo()).log("Full classpath scan took %s", (Object)stopwatch);
            Injector injector = Guice.createInjector((Module[])new Module[]{new TsunamiCliModule(scanResult, args, tsunamiConfig)});
            if (!((TsunamiCli)injector.getInstance(TsunamiCli.class)).run()) {
                System.exit(1);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Full Tsunami scan took %s.", (Object)stopwatch.stop());
        }
        catch (Throwable e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Exiting due to workflow execution exceptions.");
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            System.exit(1);
        }
    }

    private static TsunamiConfig loadConfig() {
        TsunamiConfig tsunamiConfig;
        block8: {
            ScanResult scanResult = new ClassGraph().enableAllInfo().scan();
            try {
                Optional loaderClass = TsunamiConfig.getSystemProperty((String)"tsunami.config.loader");
                Object configLoader = loaderClass.isPresent() && scanResult.getAllClassesAsMap().containsKey(loaderClass.get()) ? (ConfigLoader)scanResult.getClassInfo((String)loaderClass.get()).loadClass(ConfigLoader.class).getConstructor(new Class[0]).newInstance(new Object[0]) : new YamlConfigLoader();
                tsunamiConfig = configLoader.loadConfig();
                if (scanResult == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scanResult != null) {
                        try {
                            scanResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError("Error loading config.", e);
                }
            }
            scanResult.close();
        }
        return tsunamiConfig;
    }

    private static final class TsunamiCliModule
    extends AbstractModule {
        private final ScanResult classScanResult;
        private final String[] args;
        private final TsunamiConfig tsunamiConfig;

        TsunamiCliModule(ScanResult classScanResult, String[] args, TsunamiConfig tsunamiConfig) {
            this.classScanResult = (ScanResult)Preconditions.checkNotNull((Object)classScanResult);
            this.args = (String[])Preconditions.checkNotNull((Object)args);
            this.tsunamiConfig = (TsunamiConfig)Preconditions.checkNotNull((Object)tsunamiConfig);
        }

        protected void configure() {
            String logId = this.extractLogId(this.args);
            this.install((Module)new ClassGraphModule(this.classScanResult));
            this.install((Module)new ConfigModule(this.classScanResult, this.tsunamiConfig));
            this.install((Module)new CliOptionsModule(this.classScanResult, "TsunamiCli", this.args));
            this.install((Module)new SystemUtcClockModule());
            this.install((Module)new CommandExecutorModule());
            this.install((Module)new HttpClientModule.Builder().setLogId(logId).build());
            this.install((Module)new GoogleCloudStorageArchiverModule());
            this.install((Module)new ScanResultsArchiverModule());
            this.install((Module)new PluginExecutionModule());
            this.install((Module)new PluginLoadingModule(this.classScanResult));
            this.install((Module)new PayloadGeneratorModule(new SecureRandom()));
        }

        private String extractLogId(String[] args) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("--log-id=")) continue;
                return (String)Iterables.get((Iterable)Splitter.on((char)'=').split((CharSequence)args[i]), (int)1) + ": ";
            }
            return "";
        }
    }
}

