/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.tsunami.common.command.CommandExecutor;
import com.google.tsunami.common.command.CommandExecutorFactory;
import com.google.tsunami.common.server.LanguageServerCommand;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Qualifier;

public class RemoteServerLoader {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final List<LanguageServerCommand> commands;

    @Inject
    RemoteServerLoader(@LanguageServerCommands List<LanguageServerCommand> commands) {
        this.commands = (List)Preconditions.checkNotNull(commands);
    }

    public ImmutableList<Process> runServerProcesses() {
        ((GoogleLogger.Api)logger.atInfo()).log("Starting language server processes (if any)...");
        return (ImmutableList)this.commands.stream().map(command -> this.runProcess(CommandExecutorFactory.create((String[])new String[]{command.serverCommand(), this.getCommand("--port=", command.port()), this.getCommand("--log_id=", command.logId()), this.getCommand("--log_output=", command.outputDir()), "--trust_all_ssl_cert=" + command.trustAllSslCert(), this.getCommand("--timeout_seconds=", command.timeoutSeconds().getSeconds()), this.getCommand("--callback_address=", command.callbackAddress()), this.getCommand("--callback_port=", command.callbackPort()), this.getCommand("--polling_uri=", command.pollingUri())}))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    private String getCommand(String flag, Object command) {
        return command.toString().isEmpty() || command.toString().equals("0") ? "" : flag + String.valueOf(command);
    }

    private Optional<Process> runProcess(CommandExecutor executor) {
        try {
            return Optional.of(executor.executeAsync());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Could not execute language server binary.");
            return Optional.empty();
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LanguageServerCommands {
    }
}

