/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.collect.ImmutableList;
import com.google.tsunami.common.cli.CliOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;

@Parameters(separators="=")
public final class LanguageServerOptions
implements CliOption {
    @Parameter(names={"--plugin-server-paths"}, description="The filename of the language server to run language-specific plugins.")
    public List<String> pluginServerFilenames = ImmutableList.of();
    @Parameter(names={"--plugin-server-ports"}, description="The port of the plugin server to open connection with. If not enough ports were specified for the number of language servers specified, an open port will be chosen.")
    public List<String> pluginServerPorts = ImmutableList.of();
    @Parameter(names={"--plugin-server-rpc-deadline-seconds"}, description="The RPC deadline in seconds for the plugin servers.")
    public List<Integer> pluginServerRpcDeadlineSeconds = ImmutableList.of();
    @Parameter(names={"--remote-plugin-server-addresses", "--python-plugin-server-address"}, description="The address for remote language server (e.g. Python).")
    public List<String> remotePluginServerAddress = ImmutableList.of();
    @Parameter(names={"--remote-plugin-server-ports", "--python-plugin-server-port"}, description="The port of the remote plugin server to open connection with.")
    public List<Integer> remotePluginServerPort = ImmutableList.of();
    @Parameter(names={"--remote-plugin-server-rpc-deadline-seconds"}, description="The RPC deadline in seconds for this plugin server.")
    public List<Integer> remotePluginServerRpcDeadlineSeconds = ImmutableList.of();

    public void validate() {
        int portCounts;
        if (!this.pluginServerFilenames.isEmpty() || !this.pluginServerPorts.isEmpty()) {
            if (this.pluginServerFilenames != null && !this.pluginServerFilenames.isEmpty()) {
                for (String pluginServerFilename : this.pluginServerFilenames) {
                    if (Files.exists(Paths.get(pluginServerFilename, new String[0]), new LinkOption[0])) continue;
                    throw new ParameterException(String.format("Language server path %s does not exist", pluginServerFilename));
                }
            }
            if (this.pluginServerPorts != null && !this.pluginServerPorts.isEmpty()) {
                for (String pluginServerPort : this.pluginServerPorts) {
                    try {
                        int port = Integer.parseInt(pluginServerPort);
                        if (port <= 65535 && port > 0) continue;
                        throw new ParameterException(String.format("Port out of range. Expected [0, %s], actual %s.", 65535, pluginServerPort));
                    }
                    catch (NumberFormatException e) {
                        throw new ParameterException(String.format("Port number must be an integer. Got %s instead.", pluginServerPort), (Throwable)e);
                    }
                }
            }
            int pathCounts = this.pluginServerFilenames == null ? 0 : this.pluginServerFilenames.size();
            int n = portCounts = this.pluginServerPorts == null ? 0 : this.pluginServerPorts.size();
            if (pathCounts != portCounts) {
                throw new ParameterException(String.format("Number of plugin server paths must be equal to number of plugin server ports. Paths: %s. Ports: %s.", pathCounts, portCounts));
            }
            if (!this.pluginServerRpcDeadlineSeconds.isEmpty() && this.pluginServerRpcDeadlineSeconds.size() != pathCounts) {
                throw new ParameterException(String.format("Number of plugin server rpc deadlines must be equal to number of plugin server ports. Paths: %s. Ports: %s. Deadlines: %s", pathCounts, portCounts, this.pluginServerRpcDeadlineSeconds.size()));
            }
        }
        if (!this.remotePluginServerAddress.isEmpty()) {
            int addrCounts = this.remotePluginServerAddress.size();
            if (addrCounts != (portCounts = this.remotePluginServerPort.size())) {
                throw new ParameterException(String.format("Number of remote plugin server paths must be equal to number of plugin server ports. Addresses: %s. Ports: %s.", addrCounts, portCounts));
            }
            if (!this.remotePluginServerRpcDeadlineSeconds.isEmpty() && this.remotePluginServerRpcDeadlineSeconds.size() != addrCounts) {
                throw new ParameterException(String.format("Number of plugin server rpc deadlines must be equal to number of plugin server ports. Paths: %s. Ports: %s. Deadlines: %s", addrCounts, portCounts, this.pluginServerRpcDeadlineSeconds.size()));
            }
            for (int port : this.remotePluginServerPort) {
                if (port <= 65535 && port > 0) continue;
                throw new ParameterException(String.format("Remote plugin server port out of range. Expected [0, %s], actual %s.", 65535, port));
            }
        }
    }
}

