/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.tsunami.common.cli.CliOptionsModule;
import com.google.tsunami.common.command.CommandExecutorModule;
import com.google.tsunami.common.config.ConfigLoader;
import com.google.tsunami.common.config.ConfigModule;
import com.google.tsunami.common.config.TsunamiConfig;
import com.google.tsunami.common.config.YamlConfigLoader;
import com.google.tsunami.common.data.NetworkEndpointUtils;
import com.google.tsunami.common.data.NetworkServiceUtils;
import com.google.tsunami.common.io.archiving.GoogleCloudStorageArchiverModule;
import com.google.tsunami.common.net.http.HttpClientCliOptions;
import com.google.tsunami.common.net.http.HttpClientModule;
import com.google.tsunami.common.reflection.ClassGraphModule;
import com.google.tsunami.common.server.LanguageServerCommand;
import com.google.tsunami.common.time.SystemUtcClockModule;
import com.google.tsunami.main.cli.LanguageServerOptions;
import com.google.tsunami.main.cli.ScanResultsArchiver;
import com.google.tsunami.main.cli.ScanResultsArchiverModule;
import com.google.tsunami.main.cli.option.MainCliOptions;
import com.google.tsunami.main.cli.server.RemoteServerLoader;
import com.google.tsunami.main.cli.server.RemoteServerLoaderModule;
import com.google.tsunami.plugin.PluginExecutionModule;
import com.google.tsunami.plugin.PluginLoadingModule;
import com.google.tsunami.plugin.RemoteVulnDetectorLoadingModule;
import com.google.tsunami.plugin.payload.PayloadGeneratorModule;
import com.google.tsunami.proto.ScanResults;
import com.google.tsunami.proto.ScanStatus;
import com.google.tsunami.proto.ScanTarget;
import com.google.tsunami.workflow.DefaultScanningWorkflow;
import com.google.tsunami.workflow.ScanningWorkflowException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;

public final class TsunamiCli {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final DefaultScanningWorkflow scanningWorkflow;
    private final ScanResultsArchiver scanResultsArchiver;
    private final MainCliOptions mainCliOptions;
    private final RemoteServerLoader remoteServerLoader;

    @Inject
    TsunamiCli(DefaultScanningWorkflow scanningWorkflow, ScanResultsArchiver scanResultsArchiver, MainCliOptions mainCliOptions, RemoteServerLoader remoteServerLoader) {
        this.scanningWorkflow = (DefaultScanningWorkflow)Preconditions.checkNotNull((Object)scanningWorkflow);
        this.scanResultsArchiver = (ScanResultsArchiver)Preconditions.checkNotNull((Object)scanResultsArchiver);
        this.mainCliOptions = (MainCliOptions)Preconditions.checkNotNull((Object)mainCliOptions);
        this.remoteServerLoader = (RemoteServerLoader)Preconditions.checkNotNull((Object)remoteServerLoader);
    }

    public boolean run() throws ExecutionException, InterruptedException, ScanningWorkflowException, IOException {
        String logId = this.mainCliOptions.getLogId();
        ((GoogleLogger.Api)logger.atInfo()).log("%sTsunamiCli starting...", (Object)logId);
        ImmutableList<Process> languageServerProcesses = this.remoteServerLoader.runServerProcesses();
        ScanResults scanResults = this.scanningWorkflow.run(this.buildScanTarget());
        languageServerProcesses.forEach(Process::destroy);
        ((GoogleLogger.Api)logger.atInfo()).log("Tsunami scan finished, saving results.");
        this.saveResults(scanResults);
        if (TsunamiCli.hasSuccessfulResults(scanResults)) {
            ((GoogleLogger.Api)logger.atInfo()).log("TsunamiCli finished...");
            return true;
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Tsunami scan has failed status, message = %s.", (Object)scanResults.getStatusMessage());
        return false;
    }

    private static boolean hasSuccessfulResults(ScanResults scanResults) {
        return scanResults.getScanStatus().equals((Object)ScanStatus.SUCCEEDED) || scanResults.getScanStatus().equals((Object)ScanStatus.PARTIALLY_SUCCEEDED);
    }

    private ScanTarget buildScanTarget() {
        ScanTarget.Builder scanTargetBuilder = ScanTarget.newBuilder();
        String ip = null;
        if (this.mainCliOptions.ipV4Target != null) {
            ip = this.mainCliOptions.ipV4Target;
        } else if (this.mainCliOptions.ipV6Target != null) {
            ip = this.mainCliOptions.ipV6Target;
        }
        if (ip != null && this.mainCliOptions.hostnameTarget != null) {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forIpAndHostname((String)ip, (String)this.mainCliOptions.hostnameTarget));
        } else if (ip != null) {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forIp((String)ip));
        } else if (this.mainCliOptions.uriTarget != null) {
            scanTargetBuilder.setNetworkService(NetworkServiceUtils.buildUriNetworkService((String)this.mainCliOptions.uriTarget));
        } else {
            scanTargetBuilder.setNetworkEndpoint(NetworkEndpointUtils.forHostname((String)this.mainCliOptions.hostnameTarget));
        }
        return scanTargetBuilder.build();
    }

    private void saveResults(ScanResults scanResults) throws IOException {
        this.scanResultsArchiver.archive(scanResults);
    }

    public static void main(String[] args) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        TsunamiConfig tsunamiConfig = TsunamiCli.loadConfig();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().blacklistPackages(new String[]{"com.google.tsunami.plugin.testing"}).scan();){
            ((GoogleLogger.Api)logger.atInfo()).log("Full classpath scan took %s", (Object)stopwatch);
            Injector firstStageInjector = Guice.createInjector((Module[])new Module[]{new TsunamiCliFirstStageModule(scanResult, args, tsunamiConfig)});
            Injector injector = firstStageInjector.createChildInjector(new Module[]{new TsunamiCliModule(firstStageInjector, scanResult, tsunamiConfig)});
            if (!((TsunamiCli)injector.getInstance(TsunamiCli.class)).run()) {
                System.exit(1);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Full Tsunami scan took %s.", (Object)stopwatch.stop());
            System.exit(0);
        }
        catch (Throwable e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Exiting due to workflow execution exceptions.");
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            System.exit(1);
        }
    }

    private static TsunamiConfig loadConfig() {
        TsunamiConfig tsunamiConfig;
        block8: {
            ScanResult scanResult = new ClassGraph().enableAllInfo().scan();
            try {
                Optional loaderClass = TsunamiConfig.getSystemProperty((String)"tsunami.config.loader");
                Object configLoader = loaderClass.isPresent() && scanResult.getAllClassesAsMap().containsKey(loaderClass.get()) ? (ConfigLoader)scanResult.getClassInfo((String)loaderClass.get()).loadClass(ConfigLoader.class).getConstructor(new Class[0]).newInstance(new Object[0]) : new YamlConfigLoader();
                tsunamiConfig = configLoader.loadConfig();
                if (scanResult == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scanResult != null) {
                        try {
                            scanResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError("Error loading config.", e);
                }
            }
            scanResult.close();
        }
        return tsunamiConfig;
    }

    private static final class TsunamiCliModule
    extends AbstractModule {
        private final ScanResult classScanResult;
        private final Injector parentInjector;
        private final TsunamiConfig tsunamiConfig;

        TsunamiCliModule(Injector parentInjector, ScanResult classScanResult, TsunamiConfig tsunamiConfig) {
            this.classScanResult = (ScanResult)Preconditions.checkNotNull((Object)classScanResult);
            this.parentInjector = (Injector)Preconditions.checkNotNull((Object)parentInjector);
            this.tsunamiConfig = (TsunamiConfig)Preconditions.checkNotNull((Object)tsunamiConfig);
        }

        protected void configure() {
            MainCliOptions mco = (MainCliOptions)this.parentInjector.getInstance(MainCliOptions.class);
            LanguageServerOptions lso = (LanguageServerOptions)this.parentInjector.getInstance(LanguageServerOptions.class);
            HttpClientCliOptions hcco = (HttpClientCliOptions)this.parentInjector.getInstance(HttpClientCliOptions.class);
            ScanResultsArchiver.Options srao = (ScanResultsArchiver.Options)this.parentInjector.getInstance(ScanResultsArchiver.Options.class);
            ImmutableList<LanguageServerCommand> commands = this.extractPluginServerArgs(mco, lso, hcco, srao);
            this.install((Module)new SystemUtcClockModule());
            this.install((Module)new CommandExecutorModule());
            this.install((Module)new HttpClientModule.Builder().setLogId(mco.getLogId()).build());
            this.install((Module)new GoogleCloudStorageArchiverModule());
            this.install((Module)new ScanResultsArchiverModule());
            this.install((Module)new PluginExecutionModule());
            this.install((Module)new PluginLoadingModule(this.classScanResult));
            this.install((Module)new PayloadGeneratorModule(new SecureRandom()));
            this.install((Module)new RemoteServerLoaderModule(commands));
            this.install((Module)new RemoteVulnDetectorLoadingModule(commands));
        }

        private ImmutableList<LanguageServerCommand> extractPluginServerArgs(MainCliOptions mco, LanguageServerOptions lso, HttpClientCliOptions hcco, ScanResultsArchiver.Options srao) {
            int i;
            ArrayList commands = Lists.newArrayList();
            Boolean trustAllSslCertCli = hcco.trustAllCertificates;
            String logId = mco.getLogId();
            List<String> paths = lso.pluginServerFilenames;
            List<String> ports = lso.pluginServerPorts;
            List<Integer> rpcDeadline = lso.pluginServerRpcDeadlineSeconds;
            List<String> remoteServerAddresses = lso.remotePluginServerAddress;
            List<Integer> remoteServerPorts = lso.remotePluginServerPort;
            List<Integer> remoteRpcDeadlines = lso.remotePluginServerRpcDeadlineSeconds;
            if (paths.isEmpty() && remoteServerAddresses.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableMap callbackConfig = this.tsunamiConfig.readConfigValue("plugin.callbackserver");
            ImmutableMap httpClientConfig = this.tsunamiConfig.readConfigValue("common.net.http");
            boolean trustAllSslCertConfig = httpClientConfig.getOrDefault("trust_all_certificates", false);
            String lngOutputDir = this.extractOutputDir(srao);
            boolean lngTrustAllSslCertCli = trustAllSslCertCli != null ? trustAllSslCertCli : trustAllSslCertConfig;
            Duration lngConnectDuration = Duration.ofSeconds(httpClientConfig.getOrDefault("connect_timeout_seconds", 0).intValue());
            String lngCallbackAddress = callbackConfig.getOrDefault("callback_address", "");
            Integer lngCallbackPort = callbackConfig.getOrDefault("callback_port", 0);
            String lngPollingUri = callbackConfig.getOrDefault("polling_uri", "");
            for (i = 0; i < paths.size(); ++i) {
                commands.add(LanguageServerCommand.create((String)paths.get(i), (String)"", (String)ports.get(i), (String)logId, (String)lngOutputDir, (boolean)lngTrustAllSslCertCli, (Duration)lngConnectDuration, (String)lngCallbackAddress, (int)lngCallbackPort, (String)lngPollingUri, (int)(rpcDeadline.isEmpty() ? 0 : rpcDeadline.get(i))));
            }
            for (i = 0; i < remoteServerAddresses.size(); ++i) {
                commands.add(LanguageServerCommand.create((String)"", (String)remoteServerAddresses.get(i), (String)remoteServerPorts.get(i).toString(), (String)logId, (String)lngOutputDir, (boolean)lngTrustAllSslCertCli, (Duration)lngConnectDuration, (String)lngCallbackAddress, (int)lngCallbackPort, (String)lngPollingUri, (int)(remoteRpcDeadlines.isEmpty() ? 0 : remoteRpcDeadlines.get(i))));
            }
            return ImmutableList.copyOf((Collection)commands);
        }

        private String extractOutputDir(ScanResultsArchiver.Options sra) {
            if (!Strings.isNullOrEmpty((String)sra.localOutputFilename)) {
                return Path.of(sra.localOutputFilename, new String[0]).getParent().toString();
            }
            return "";
        }
    }

    private static final class TsunamiCliFirstStageModule
    extends AbstractModule {
        private final ScanResult classScanResult;
        private final String[] args;
        private final TsunamiConfig tsunamiConfig;

        TsunamiCliFirstStageModule(ScanResult classScanResult, String[] args, TsunamiConfig tsunamiConfig) {
            this.classScanResult = (ScanResult)Preconditions.checkNotNull((Object)classScanResult);
            this.args = (String[])Preconditions.checkNotNull((Object)args);
            this.tsunamiConfig = (TsunamiConfig)Preconditions.checkNotNull((Object)tsunamiConfig);
        }

        protected void configure() {
            this.install((Module)new ClassGraphModule(this.classScanResult));
            this.install((Module)new ConfigModule(this.classScanResult, this.tsunamiConfig));
            this.install((Module)new CliOptionsModule(this.classScanResult, "TsunamiCli", this.args));
        }
    }
}

