/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.main.cli.option;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.tsunami.common.cli.CliOption;
import com.google.tsunami.main.cli.option.validator.IpV4Validator;
import com.google.tsunami.main.cli.option.validator.IpV6Validator;
import java.util.ArrayList;

@Parameters(separators="=")
public final class MainCliOptions
implements CliOption {
    @Parameter(names={"--ip-v4-target"}, description="The IP v4 address of the scanning target.", validateWith=IpV4Validator.class)
    public String ipV4Target;
    @Parameter(names={"--ip-v6-target"}, description="The IP v6 address of the scanning target.", validateWith=IpV6Validator.class)
    public String ipV6Target;
    @Parameter(names={"--hostname-target"}, description="The hostname of the scanning target.")
    public String hostnameTarget;
    @Parameter(names={"--log-id"}, description="A log ID to print in front of the logs.")
    public String logId;

    public void validate() {
        ArrayList<String> nonEmptyTargets = new ArrayList<String>();
        if (this.ipV4Target != null) {
            nonEmptyTargets.add("--ip-v4-target");
        }
        if (this.ipV6Target != null) {
            nonEmptyTargets.add("--ip-v6-target");
        }
        if (this.hostnameTarget != null) {
            nonEmptyTargets.add("--hostname-target");
        }
        if (nonEmptyTargets.isEmpty()) {
            throw new ParameterException("One of the following parameters is expected: --ip-v4-target, --ip-v6-target, --hostname-target");
        }
    }
}

