/*
 * Decompiled with CFR 0.152.
 */
package com.google.zetasql;

import com.google.auto.service.AutoService;
import com.google.zetasql.ClientChannelProvider;
import com.google.zetasql.cz.adamh.utils.NativeUtils;
import com.google.zetasql.io.grpc.Channel;
import com.google.zetasql.io.grpc.LoadBalancerProvider;
import com.google.zetasql.io.grpc.LoadBalancerRegistry;
import com.google.zetasql.io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelException;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

@AutoService(value=ClientChannelProvider.class)
public class JniChannelProvider
implements ClientChannelProvider {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private static Channel channel = null;

    private static native SocketChannel getSocketChannel() throws IOException;

    private synchronized Channel getChannelInternal() {
        if (channel == null) {
            channel = NettyChannelBuilder.forAddress((SocketAddress)ADDRESS).channelType(SocketPairChannel.class).usePlaintext().build();
        }
        return channel;
    }

    public Channel getChannel() {
        return this.getChannelInternal();
    }

    static {
        System.setProperty("zetasql.local_service.class", JniChannelProvider.class.getName().replace('.', '/'));
        try {
            NativeUtils.loadLibraryFromJar("/zetasql/local_service/liblocal_service_jni.so");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            LoadBalancerRegistry.getDefaultRegistry().register(Class.forName("com.google.zetasql.io.grpc.internal.PickFirstLoadBalancerProvider").asSubclass(LoadBalancerProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class SocketPairChannel
    extends NioSocketChannel {
        private final Object stateLock = new Object();
        private boolean calledDoConnect = false;

        private static SocketChannel newSocket() {
            try {
                return JniChannelProvider.getSocketChannel();
            }
            catch (IOException e) {
                throw new ChannelException("Failed to open a socket.", (Throwable)e);
            }
        }

        public SocketPairChannel() {
            super(SocketPairChannel.newSocket());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.calledDoConnect && super.isActive();
            }
        }

        public InetSocketAddress localAddress() {
            return ADDRESS;
        }

        public InetSocketAddress remoteAddress() {
            return ADDRESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
            if (!ADDRESS.equals(remoteAddress)) {
                throw new IllegalArgumentException("Invalid remoteAddress");
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.calledDoConnect = true;
            }
            return true;
        }
    }
}

