/*
 * Decompiled with CFR 0.152.
 */
package com.google.zetasql;

import com.google.auto.service.AutoService;
import com.google.zetasql.ClientChannelProvider;
import com.google.zetasql.cz.adamh.utils.NativeUtils;
import com.google.zetasql.io.grpc.Channel;
import com.google.zetasql.io.grpc.LoadBalancerProvider;
import com.google.zetasql.io.grpc.LoadBalancerRegistry;
import com.google.zetasql.io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ThreadFactory;

@AutoService(value=ClientChannelProvider.class)
public class JniChannelProvider
implements ClientChannelProvider {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private static Channel channel = null;

    private static String getLibraryPath() {
        String path = System.getProperty("zetasql.local_service.path");
        if (path != null) {
            return path;
        }
        String arch = System.getProperty("os.arch");
        if (!"x86_64".equals(arch) && !"amd64".equals(arch)) {
            throw new RuntimeException("Unsupported os.arch");
        }
        path = "/zetasql/local_service/";
        String os = System.getProperty("os.name");
        if ("Linux".equals(os)) {
            return path + "liblocal_service_jni.so";
        }
        if ("Mac OS X".equals(os)) {
            return path + "liblocal_service_jni.jnilib";
        }
        throw new RuntimeException("Unsupported os");
    }

    private static native SocketChannel getSocketChannel() throws IOException;

    private synchronized Channel getChannelInternal() {
        if (channel == null) {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("zetasqlJniChannel", true);
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)threadFactory);
            channel = NettyChannelBuilder.forAddress((SocketAddress)ADDRESS).channelType(SocketPairChannel.class).eventLoopGroup((EventLoopGroup)eventLoopGroup).usePlaintext().build();
        }
        return channel;
    }

    public Channel getChannel() {
        return this.getChannelInternal();
    }

    static {
        System.setProperty("zetasql.local_service.class", JniChannelProvider.class.getName().replace('.', '/'));
        try {
            NativeUtils.loadLibraryFromJar(JniChannelProvider.getLibraryPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            LoadBalancerRegistry.getDefaultRegistry().register(Class.forName("com.google.zetasql.io.grpc.internal.PickFirstLoadBalancerProvider").asSubclass(LoadBalancerProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class SocketPairChannel
    extends NioSocketChannel {
        private final Object stateLock = new Object();
        private boolean calledDoConnect = false;

        private static SocketChannel newSocket() {
            try {
                return JniChannelProvider.getSocketChannel();
            }
            catch (IOException e) {
                throw new ChannelException("Failed to open a socket.", (Throwable)e);
            }
        }

        public SocketPairChannel() {
            super(SocketPairChannel.newSocket());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.calledDoConnect && super.isActive();
            }
        }

        public InetSocketAddress localAddress() {
            return ADDRESS;
        }

        public InetSocketAddress remoteAddress() {
            return ADDRESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
            if (!ADDRESS.equals(remoteAddress)) {
                throw new IllegalArgumentException("Invalid remoteAddress");
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.calledDoConnect = true;
            }
            return true;
        }
    }
}

