/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

final class AuthUtil {
    private static final Collection<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/glass.timeline", "https://www.googleapis.com/auth/userinfo.profile");
    private final DataStoreFactory dataStoreFactory = new MemoryDataStoreFactory();
    private final String clientID;
    private final String clientSecret;

    AuthUtil(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
    }

    public AuthorizationCodeFlow newAuthorizationCodeFlow() throws IOException {
        return new GoogleAuthorizationCodeFlow.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), this.clientID, this.clientSecret, SCOPES).setAccessType("offline").setDataStoreFactory(this.dataStoreFactory).build();
    }

    public Credential getCredential(String userId) throws IOException {
        return userId == null ? null : this.newAuthorizationCodeFlow().loadCredential(userId);
    }
}

