/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
final class DecodeHelper {
    private static final int MAX_PIXELS = 0x800000;
    private static final Map<DecodeHintType, Object> HINTS = new EnumMap(DecodeHintType.class);

    private DecodeHelper() {
    }

    static Collection<Result> processStream(InputStream is) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(is);
        }
        catch (CMMException | IllegalArgumentException e) {
            throw new IOException(e);
        }
        if (image == null) {
            throw new IOException("No image");
        }
        if (image.getHeight() <= 1 || image.getWidth() <= 1 || image.getHeight() * image.getWidth() > 0x800000) {
            throw new IOException("Dimensions out of bounds: " + image.getWidth() + 'x' + image.getHeight());
        }
        return DecodeHelper.processImage((BufferedImage)image);
    }

    private static Collection<Result> processImage(BufferedImage image) {
        MultiFormatReader reader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
        ArrayList<Result> results = new ArrayList<Result>(1);
        if (results.isEmpty()) {
            try {
                Result theResult = reader.decode(bitmap, HINTS);
                if (theResult != null) {
                    results.add(theResult);
                }
            }
            catch (ReaderException re) {
                // empty catch block
            }
        }
        if (results.isEmpty()) {
            try {
                BinaryBitmap hybridBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                Result theResult = reader.decode(hybridBitmap, HINTS);
                if (theResult != null) {
                    results.add(theResult);
                }
            }
            catch (ReaderException re) {
                // empty catch block
            }
        }
        return results;
    }

    static {
        HINTS.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
    }
}

