/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.services.mirror.model.Contact;
import com.google.api.services.mirror.model.Subscription;
import com.google.api.services.mirror.model.TimelineItem;
import com.google.zxing.client.glass.AuthUtil;
import com.google.zxing.client.glass.mirror.MirrorClient;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NewUserSetupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(NewUserSetupServlet.class);
    private static final String BS_ID = "barcode-scanner";
    private AuthUtil authUtil;
    private String baseURL;
    private String notificationCallbackURL;
    private String subscriptionVerifyToken;

    public void init(ServletConfig servletConfig) {
        ServletContext context = servletConfig.getServletContext();
        this.authUtil = new AuthUtil(context.getInitParameter("CLIENT_ID"), context.getInitParameter("CLIENT_SECRET"));
        this.baseURL = context.getInitParameter("BASE_URL");
        this.notificationCallbackURL = this.baseURL + "/notification";
        this.subscriptionVerifyToken = context.getInitParameter("SUBSCRIPTION_VERIFY_TOKEN");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirect;
        if (request.getParameter("error") != null) {
            log.warn("OAuth error: {}", (Object)Arrays.toString(request.getParameterValues("error")));
            redirect = this.baseURL;
        } else {
            GenericUrl url1 = new GenericUrl(request.getRequestURL().toString());
            url1.setRawPath("/oauth2callback");
            String callbackURL = url1.build();
            String code = request.getParameter("code");
            if (code == null) {
                log.info("New OAuth flow");
                AuthorizationCodeFlow flow = this.authUtil.newAuthorizationCodeFlow();
                AuthorizationCodeRequestUrl url = flow.newAuthorizationUrl().setRedirectUri(callbackURL);
                url.set("approval_prompt", (Object)"force");
                redirect = url.build();
            } else {
                log.info("OAuth response, code: {}", (Object)code);
                AuthorizationCodeFlow flow = this.authUtil.newAuthorizationCodeFlow();
                TokenResponse tokenResponse = flow.newTokenRequest(code).setRedirectUri(callbackURL).execute();
                String userId = ((GoogleTokenResponse)tokenResponse).parseIdToken().getPayload().getSubject();
                flow.createAndStoreCredential(tokenResponse, userId);
                ResourceBundle resources = ResourceBundle.getBundle("Strings", request.getLocale());
                this.bootstrapNewUser(userId, resources);
                redirect = "glass/index.jspx";
            }
        }
        response.sendRedirect(redirect);
    }

    private void bootstrapNewUser(String userId, ResourceBundle resources) throws IOException {
        Credential credential = this.authUtil.newAuthorizationCodeFlow().loadCredential(userId);
        String appName = resources.getString("app.title");
        MirrorClient mirrorClient = MirrorClient.get();
        boolean contactExists = false;
        for (Contact contact : mirrorClient.listContacts(credential)) {
            if (!BS_ID.equals(contact.getId())) continue;
            contactExists = true;
            break;
        }
        if (!contactExists) {
            Contact contact = new Contact();
            contact.setId(BS_ID);
            contact.setDisplayName(appName);
            contact.setAcceptTypes(Arrays.asList("image/png", "image/jpeg", "image/gif", "image/bmp"));
            mirrorClient.insertContact(credential, contact);
        }
        boolean subscriptionExists = false;
        for (Subscription subscription : mirrorClient.listSubscriptions(credential)) {
            if (!this.notificationCallbackURL.equals(subscription.getCallbackUrl())) continue;
            subscriptionExists = true;
            break;
        }
        if (!subscriptionExists) {
            Subscription subscription = new Subscription();
            subscription.setCollection("timeline");
            subscription.setOperation(Collections.singletonList("INSERT"));
            subscription.setCallbackUrl(this.notificationCallbackURL);
            subscription.setVerifyToken(this.subscriptionVerifyToken);
            subscription.setUserToken(userId);
            mirrorClient.insertSubscription(credential, subscription);
        }
        TimelineItem timelineItem = new TimelineItem();
        timelineItem.setTitle(MessageFormat.format(resources.getString("setup.welcome.title"), appName));
        timelineItem.setText(MessageFormat.format(resources.getString("setup.welcome.text"), appName));
        mirrorClient.insertTimelineItem(credential, timelineItem);
    }
}

