/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.mirror.model.Attachment;
import com.google.api.services.mirror.model.TimelineItem;
import com.google.zxing.Result;
import com.google.zxing.client.glass.DecodeHelper;
import com.google.zxing.client.glass.mirror.MirrorClient;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.URIParsedResult;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;

/*
 * Exception performing whole class analysis ignored.
 */
final class NotificationCallable
implements Callable<Void> {
    private final Credential credential;
    private final String timelineItemID;
    private final ResourceBundle resources;

    NotificationCallable(Credential credential, String timelineItemID, ResourceBundle resources) {
        this.credential = credential;
        this.timelineItemID = timelineItemID;
        this.resources = resources;
    }

    @Override
    public Void call() throws Exception {
        MirrorClient mirrorClient = MirrorClient.get();
        TimelineItem timelineItem = mirrorClient.getTimelineItem(this.credential, this.timelineItemID);
        if (timelineItem == null) {
            return null;
        }
        List attachments = timelineItem.getAttachments();
        if (attachments == null || attachments.isEmpty()) {
            return null;
        }
        Attachment attachment = (Attachment)attachments.get(0);
        String attachmentId = attachment.getId();
        String errorMessage = null;
        Collection results = null;
        try (InputStream in = mirrorClient.getAttachmentInputStream(this.credential, this.timelineItemID, attachmentId);){
            results = DecodeHelper.processStream((InputStream)in);
        }
        catch (IOException | RuntimeException e) {
            errorMessage = e.toString();
        }
        if (results == null || results.isEmpty()) {
            TimelineItem resultTimelineItem = new TimelineItem();
            if (errorMessage == null) {
                resultTimelineItem.setTitle(this.resources.getString("scan.result.notfound.title"));
                resultTimelineItem.setText(this.resources.getString("scan.result.notfound.text"));
            } else {
                resultTimelineItem.setTitle(this.resources.getString("scan.result.error.title"));
                resultTimelineItem.setText(MessageFormat.format(this.resources.getString("scan.result.error.text"), errorMessage));
            }
            mirrorClient.insertTimelineItem(this.credential, resultTimelineItem);
        } else {
            for (Result result : results) {
                ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                TimelineItem resultTimelineItem = new TimelineItem();
                resultTimelineItem.setText(parsedResult.getDisplayResult());
                resultTimelineItem.setTitle(MessageFormat.format(this.resources.getString("scan.result.success.title"), parsedResult.getType()));
                NotificationCallable.addResultDetailToTimelineItem((ParsedResult)parsedResult, (TimelineItem)resultTimelineItem);
                mirrorClient.insertTimelineItem(this.credential, resultTimelineItem);
            }
        }
        return null;
    }

    private static void addResultDetailToTimelineItem(ParsedResult parsedResult, TimelineItem item) {
        if (parsedResult instanceof URIParsedResult) {
            NotificationCallable.addURIResultDetailToTimelineItem((URIParsedResult)((URIParsedResult)parsedResult), (TimelineItem)item);
        }
    }

    private static void addURIResultDetailToTimelineItem(URIParsedResult parsedResult, TimelineItem item) {
        String uri = parsedResult.getURI();
        item.setHtml("<a href=\"" + uri + "\">" + parsedResult.getDisplayResult() + "</a>");
        item.setCanonicalUrl(uri);
    }
}

