/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.mirror.model.Notification;
import com.google.zxing.client.glass.AuthUtil;
import com.google.zxing.client.glass.NotificationCallable;
import java.io.IOException;
import java.io.Reader;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class NotificationServlet
extends HttpServlet {
    private ExecutorService executor;
    private final JsonObjectParser jsonParser = new JsonObjectParser((JsonFactory)new JacksonFactory());
    private AuthUtil authUtil;
    private String subscriptionVerifyToken;

    public void init(ServletConfig servletConfig) {
        ServletContext context = servletConfig.getServletContext();
        this.authUtil = new AuthUtil(context.getInitParameter("CLIENT_ID"), context.getInitParameter("CLIENT_SECRET"));
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.subscriptionVerifyToken = context.getInitParameter("SUBSCRIPTION_VERIFY_TOKEN");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Notification notification = (Notification)this.jsonParser.parseAndClose((Reader)request.getReader(), Notification.class);
        if (!this.subscriptionVerifyToken.equals(notification.getVerifyToken())) {
            response.sendError(400);
            return;
        }
        String userId = notification.getUserToken();
        Credential credential = this.authUtil.newAuthorizationCodeFlow().loadCredential(userId);
        String timelineItemID = notification.getItemId();
        ResourceBundle resources = ResourceBundle.getBundle("Strings", request.getLocale());
        this.executor.submit(new NotificationCallable(credential, timelineItemID, resources));
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

