/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.glass.mirror;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.mirror.model.Attachment;
import com.google.api.services.mirror.model.Contact;
import com.google.api.services.mirror.model.Subscription;
import com.google.api.services.mirror.model.TimelineItem;
import com.google.common.collect.Sets;
import com.google.zxing.client.glass.mirror.MirrorClient;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MemoryMirrorClient
extends MirrorClient {
    private static final Logger log = LoggerFactory.getLogger(MemoryMirrorClient.class);
    private static final String FAKE_ATTACHMENT_ID = "0123";
    private final Collection<Contact> contacts = Collections.synchronizedCollection(Sets.newHashSet());
    private final Collection<Subscription> subscriptions = Collections.synchronizedCollection(Sets.newHashSet());

    MemoryMirrorClient() {
    }

    public void insertContact(Credential credential, Contact contact) {
        log.info("Insert Contact: {}", (Object)contact);
        this.contacts.add(contact);
    }

    public Collection<Contact> listContacts(Credential credential) {
        log.info("Contacts: {}", (Object)this.contacts);
        return this.contacts;
    }

    public void insertTimelineItem(Credential credential, TimelineItem item) {
        log.info("Insert Timeline: {}", (Object)item);
    }

    public void insertSubscription(Credential credential, Subscription subscription) {
        log.info("Insert Subscription: {}", (Object)subscription);
        this.subscriptions.add(subscription);
    }

    public Collection<Subscription> listSubscriptions(Credential credential) {
        log.info("Subscriptions: {}", (Object)this.subscriptions);
        return this.subscriptions;
    }

    public TimelineItem getTimelineItem(Credential credential, String id) {
        log.info("Get Timeline {}", (Object)id);
        TimelineItem timelineItem = new TimelineItem();
        timelineItem.setId(id);
        Attachment fakeAttachment = new Attachment();
        fakeAttachment.setId(FAKE_ATTACHMENT_ID);
        timelineItem.setAttachments(Collections.singletonList(fakeAttachment));
        return timelineItem;
    }

    public InputStream getAttachmentInputStream(Credential credential, String timelineItemId, String attachmentId) {
        log.info("Get Attachment {} {}", (Object)timelineItemId, (Object)attachmentId);
        if (!FAKE_ATTACHMENT_ID.equals(attachmentId)) {
            return null;
        }
        return MemoryMirrorClient.class.getResourceAsStream("/test.jpg");
    }
}

