/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import com.google.zxing.web.ServletContextLogHandler;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DecodeServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(DecodeServlet.class.getName());
    private static final long MAX_IMAGE_SIZE = 2000000L;
    private static final int MAX_PIXELS = 0x800000;
    private static final byte[] REMAINDER_BUFFER = new byte[8192];
    private static final Map<DecodeHintType, Object> HINTS = new EnumMap(DecodeHintType.class);
    private static final Map<DecodeHintType, Object> HINTS_PURE;
    private DiskFileItemFactory diskFileItemFactory;
    private Collection<String> blockedURLSubstrings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        Logger logger = Logger.getLogger("com.google.zxing");
        ServletContext context = servletConfig.getServletContext();
        logger.addHandler((Handler)new ServletContextLogHandler(context));
        File repository = (File)context.getAttribute("javax.servlet.context.tempdir");
        FileCleaningTracker fileCleaningTracker = FileCleanerCleanup.getFileCleaningTracker((ServletContext)context);
        this.diskFileItemFactory = new DiskFileItemFactory(65536, repository);
        this.diskFileItemFactory.setFileCleaningTracker(fileCleaningTracker);
        this.blockedURLSubstrings = new ArrayList();
        InputStream in = DecodeServlet.class.getResourceAsStream("/private/uri-block-substrings.txt");
        if (in != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        this.blockedURLSubstrings.add(line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
        }
        log.info("Blocking URIs containing: " + this.blockedURLSubstrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpURLConnection connection;
        URL imageURL;
        URI imageURI;
        String imageURIString = request.getParameter("u");
        if (imageURIString == null || imageURIString.isEmpty()) {
            log.info("URI was empty");
            response.sendRedirect("badurl.jspx");
            return;
        }
        imageURIString = imageURIString.trim();
        for (String substring : this.blockedURLSubstrings) {
            if (!imageURIString.contains(substring)) continue;
            log.info("Disallowed URI " + imageURIString);
            response.sendRedirect("badurl.jspx");
            return;
        }
        try {
            imageURI = new URI(imageURIString);
            if (imageURI.getScheme() == null) {
                imageURI = new URI("http://" + imageURIString);
            }
        }
        catch (URISyntaxException urise) {
            log.info("URI " + imageURIString + " was not valid: " + urise);
            response.sendRedirect("badurl.jspx");
            return;
        }
        if ("data".equals(imageURI.getScheme())) {
            try {
                BufferedImage image = ImageReader.readDataURIImage((URI)imageURI);
                DecodeServlet.processImage((BufferedImage)image, (ServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IOException ioe) {
                log.info(ioe.toString());
                response.sendRedirect("badurl.jspx");
            }
            return;
        }
        try {
            imageURL = imageURI.toURL();
        }
        catch (MalformedURLException ignored) {
            log.info("URI was not valid: " + imageURIString);
            response.sendRedirect("badurl.jspx");
            return;
        }
        try {
            connection = (HttpURLConnection)imageURL.openConnection();
        }
        catch (IllegalArgumentException ignored) {
            log.info("URI could not be opened: " + imageURL);
            response.sendRedirect("badurl.jspx");
            return;
        }
        connection.setAllowUserInteraction(false);
        connection.setReadTimeout(5000);
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "zxing.org");
        connection.setRequestProperty("Connection", "close");
        try {
            try {
                connection.connect();
            }
            catch (IOException ioe) {
                log.info(ioe.toString());
                response.sendRedirect("badurl.jspx");
                connection.disconnect();
                return;
            }
            InputStream is = null;
            try {
                is = connection.getInputStream();
                if (connection.getResponseCode() != 200) {
                    log.info("Unsuccessful return code: " + connection.getResponseCode());
                    response.sendRedirect("badurl.jspx");
                    return;
                }
                if ((long)connection.getHeaderFieldInt("Content-Length", 0) > 2000000L) {
                    log.info("Too large");
                    response.sendRedirect("badimage.jspx");
                    return;
                }
                log.info("Decoding " + imageURL);
                DecodeServlet.processStream((InputStream)is, (ServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IOException ioe) {
                log.info(ioe.toString());
                response.sendRedirect("badurl.jspx");
                return;
            }
            finally {
                if (is != null) {
                    DecodeServlet.consumeRemainder((InputStream)is);
                    is.close();
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private static void consumeRemainder(InputStream is) {
        try {
            int available;
            while ((available = is.available()) > 0) {
                is.read(REMAINDER_BUFFER, 0, available);
            }
        }
        catch (IOException ioe) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            log.info("File upload was not multipart");
            response.sendRedirect("badimage.jspx");
            return;
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.diskFileItemFactory);
        upload.setFileSizeMax(2000000L);
        try {
            for (FileItem item : upload.parseRequest(request)) {
                if (item.isFormField()) continue;
                if (item.getSize() <= 2000000L) {
                    log.info("Decoding uploaded file");
                    InputStream is = item.getInputStream();
                    try {
                        DecodeServlet.processStream((InputStream)is, (ServletRequest)request, (HttpServletResponse)response);
                        break;
                    }
                    finally {
                        is.close();
                    }
                }
                log.info("Too large");
                response.sendRedirect("badimage.jspx");
                break;
            }
        }
        catch (FileUploadException fue) {
            log.info(fue.toString());
            response.sendRedirect("badimage.jspx");
        }
    }

    private static void processStream(InputStream is, ServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(is);
        }
        catch (IOException ioe) {
            log.info(ioe.toString());
            response.sendRedirect("badimage.jspx");
            return;
        }
        catch (CMMException cmme) {
            log.info(cmme.toString());
            response.sendRedirect("badimage.jspx");
            return;
        }
        catch (IllegalArgumentException iae) {
            log.info(iae.toString());
            response.sendRedirect("badimage.jspx");
            return;
        }
        if (image == null) {
            response.sendRedirect("badimage.jspx");
            return;
        }
        if (image.getHeight() <= 1 || image.getWidth() <= 1 || image.getHeight() * image.getWidth() > 0x800000) {
            log.info("Dimensions too large: " + image.getWidth() + 'x' + image.getHeight());
            response.sendRedirect("badimage.jspx");
            return;
        }
        DecodeServlet.processImage((BufferedImage)image, (ServletRequest)request, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processImage(BufferedImage image, ServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean minimalOutput;
        MultiFormatReader reader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
        ArrayList<Result> results = new ArrayList<Result>(1);
        ReaderException savedException = null;
        try {
            Result theResult;
            try {
                GenericMultipleBarcodeReader multiReader = new GenericMultipleBarcodeReader((Reader)reader);
                Result[] theResults = multiReader.decodeMultiple(bitmap, HINTS);
                if (theResults != null) {
                    results.addAll(Arrays.asList(theResults));
                }
            }
            catch (ReaderException re) {
                savedException = re;
            }
            if (results.isEmpty()) {
                try {
                    theResult = reader.decode(bitmap, HINTS_PURE);
                    if (theResult != null) {
                        results.add(theResult);
                    }
                }
                catch (ReaderException re) {
                    savedException = re;
                }
            }
            if (results.isEmpty()) {
                try {
                    theResult = reader.decode(bitmap, HINTS);
                    if (theResult != null) {
                        results.add(theResult);
                    }
                }
                catch (ReaderException re) {
                    savedException = re;
                }
            }
            if (results.isEmpty()) {
                try {
                    BinaryBitmap hybridBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                    Result theResult2 = reader.decode(hybridBitmap, HINTS);
                    if (theResult2 != null) {
                        results.add(theResult2);
                    }
                }
                catch (ReaderException re) {
                    savedException = re;
                }
            }
            if (results.isEmpty()) {
                DecodeServlet.handleException((ReaderException)savedException, (HttpServletResponse)response);
                return;
            }
        }
        catch (RuntimeException re) {
            log.log(Level.WARNING, "Unexpected exception from library", re);
            throw new ServletException((Throwable)re);
        }
        String fullParameter = request.getParameter("full");
        boolean bl = minimalOutput = fullParameter != null && !Boolean.parseBoolean(fullParameter);
        if (minimalOutput) {
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF8");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), Charset.forName("UTF-8"));
            try {
                for (Result result : results) {
                    out.write(result.getText());
                    ((Writer)out).write(10);
                }
            }
            finally {
                ((Writer)out).close();
            }
        } else {
            request.setAttribute("results", results);
            request.getRequestDispatcher("decoderesult.jspx").forward(request, (ServletResponse)response);
        }
    }

    private static void handleException(ReaderException re, HttpServletResponse response) throws IOException {
        if (re instanceof NotFoundException) {
            log.info("Not found: " + (Object)((Object)re));
            response.sendRedirect("notfound.jspx");
        } else if (re instanceof FormatException) {
            log.info("Format problem: " + (Object)((Object)re));
            response.sendRedirect("format.jspx");
        } else if (re instanceof ChecksumException) {
            log.info("Checksum problem: " + (Object)((Object)re));
            response.sendRedirect("format.jspx");
        } else {
            log.info("Unknown problem: " + (Object)((Object)re));
            response.sendRedirect("notfound.jspx");
        }
    }

    static {
        HINTS.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
        HINTS_PURE = new EnumMap(HINTS);
        HINTS_PURE.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
    }
}

