/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.web.ChartServletRequestParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EnumMap;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
@WebServlet(value={"/w/chart"})
public final class ChartServlet
extends HttpServlet {
    private static final int MAX_DIMENSION = 4096;
    private static final Collection<Charset> SUPPORTED_OUTPUT_ENCODINGS = ImmutableSet.builder().add((Object)StandardCharsets.UTF_8).add((Object)StandardCharsets.ISO_8859_1).add((Object)Charset.forName("Shift_JIS")).build();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChartServlet.doEncode((ServletRequest)request, (HttpServletResponse)response, (boolean)false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChartServlet.doEncode((ServletRequest)request, (HttpServletResponse)response, (boolean)true);
    }

    private static void doEncode(ServletRequest request, HttpServletResponse response, boolean isPost) throws IOException {
        BitMatrix matrix;
        ChartServletRequestParameters parameters;
        try {
            parameters = ChartServlet.doParseParameters((ServletRequest)request, (boolean)isPost);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            response.sendError(400, e.toString());
            return;
        }
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, (Object)parameters.getMargin());
        if (!StandardCharsets.ISO_8859_1.equals(parameters.getOutputEncoding())) {
            hints.put(EncodeHintType.CHARACTER_SET, (Object)parameters.getOutputEncoding().name());
        }
        hints.put(EncodeHintType.ERROR_CORRECTION, (Object)parameters.getEcLevel());
        try {
            matrix = new QRCodeWriter().encode(parameters.getText(), BarcodeFormat.QR_CODE, parameters.getWidth(), parameters.getHeight(), hints);
        }
        catch (WriterException we) {
            response.sendError(400, we.toString());
            return;
        }
        ByteArrayOutputStream pngOut = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"PNG", (OutputStream)pngOut);
        byte[] pngData = pngOut.toByteArray();
        response.setContentType("image/png");
        response.setContentLength(pngData.length);
        response.setHeader("Cache-Control", "public");
        response.getOutputStream().write(pngData);
    }

    private static ChartServletRequestParameters doParseParameters(ServletRequest request, boolean readBody) throws IOException {
        Preconditions.checkArgument((boolean)"qr".equals(request.getParameter("cht")), (Object)"Bad type");
        String widthXHeight = request.getParameter("chs");
        Preconditions.checkNotNull((Object)widthXHeight, (Object)"No size");
        int xIndex = widthXHeight.indexOf(120);
        Preconditions.checkArgument((xIndex >= 0 ? 1 : 0) != 0, (Object)"Bad size");
        int width = Integer.parseInt(widthXHeight.substring(0, xIndex));
        int height = Integer.parseInt(widthXHeight.substring(xIndex + 1));
        Preconditions.checkArgument((width > 0 && height > 0 ? 1 : 0) != 0, (Object)"Bad size");
        Preconditions.checkArgument((width <= 4096 && height <= 4096 ? 1 : 0) != 0, (Object)"Bad size");
        String outputEncodingName = request.getParameter("choe");
        Charset outputEncoding = StandardCharsets.UTF_8;
        if (outputEncodingName != null) {
            outputEncoding = Charset.forName(outputEncodingName);
            Preconditions.checkArgument((boolean)SUPPORTED_OUTPUT_ENCODINGS.contains(outputEncoding), (Object)"Bad output encoding");
        }
        ErrorCorrectionLevel ecLevel = ErrorCorrectionLevel.L;
        int margin = 4;
        String ldString = request.getParameter("chld");
        if (ldString != null) {
            int pipeIndex = ldString.indexOf(124);
            if (pipeIndex < 0) {
                ecLevel = ErrorCorrectionLevel.valueOf((String)ldString);
            } else {
                ecLevel = ErrorCorrectionLevel.valueOf((String)ldString.substring(0, pipeIndex));
                margin = Integer.parseInt(ldString.substring(pipeIndex + 1));
                Preconditions.checkArgument((margin > 0 ? 1 : 0) != 0, (Object)"Bad margin");
            }
        }
        String text = readBody ? CharStreams.toString((Readable)request.getReader()) : request.getParameter("chl");
        Preconditions.checkArgument((text != null && !text.isEmpty() ? 1 : 0) != 0, (Object)"No input");
        return new ChartServletRequestParameters(width, height, outputEncoding, ecLevel, margin, text);
    }
}

