/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import com.google.zxing.web.ServletContextLogHandler;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

/*
 * Exception performing whole class analysis ignored.
 */
@MultipartConfig(maxFileSize=0x4000000L, maxRequestSize=0x4000000L, fileSizeThreshold=0x100000, location="/tmp")
@WebServlet(value={"/w/decode"}, loadOnStartup=1)
public final class DecodeServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(DecodeServlet.class.getName());
    private static final long MAX_IMAGE_SIZE = 0x4000000L;
    private static final int MAX_PIXELS = 0x4000000;
    private static final byte[] REMAINDER_BUFFER = new byte[65536];
    private static final Map<DecodeHintType, Object> HINTS = new EnumMap(DecodeHintType.class);
    private static final Map<DecodeHintType, Object> HINTS_PURE;
    private Iterable<String> blockedURLSubstrings;

    public void init(ServletConfig servletConfig) throws ServletException {
        Logger logger = Logger.getLogger("com.google.zxing");
        ServletContext context = servletConfig.getServletContext();
        logger.addHandler((Handler)new ServletContextLogHandler(context));
        URL blockURL = context.getClassLoader().getResource("/private/uri-block-substrings.txt");
        if (blockURL == null) {
            this.blockedURLSubstrings = Collections.emptyList();
        } else {
            try {
                this.blockedURLSubstrings = Resources.readLines((URL)blockURL, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
            log.info("Blocking URIs containing: " + this.blockedURLSubstrings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpURLConnection connection;
        URL imageURL;
        URI imageURI;
        String imageURIString = request.getParameter("u");
        if (imageURIString == null || imageURIString.isEmpty()) {
            log.info("URI was empty");
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        imageURIString = imageURIString.trim();
        for (CharSequence substring : this.blockedURLSubstrings) {
            if (!imageURIString.contains(substring)) continue;
            log.info("Disallowed URI " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try {
            imageURI = new URI(imageURIString);
            if (imageURI.getScheme() == null) {
                imageURI = new URI("http://" + imageURIString);
            }
        }
        catch (URISyntaxException urise) {
            log.info("URI " + imageURIString + " was not valid: " + urise);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        if ("data".equals(imageURI.getScheme())) {
            try {
                BufferedImage image = ImageReader.readDataURIImage((URI)imageURI);
                DecodeServlet.processImage((BufferedImage)image, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IOException ioe) {
                log.info(ioe.toString());
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            }
            return;
        }
        try {
            imageURL = imageURI.toURL();
        }
        catch (MalformedURLException ignored) {
            log.info("URI was not valid: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        String protocol = imageURL.getProtocol();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            log.info("URI was not valid: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try {
            connection = (HttpURLConnection)imageURL.openConnection();
        }
        catch (IllegalArgumentException ignored) {
            log.info("URI could not be opened: " + imageURL);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        connection.setAllowUserInteraction(false);
        connection.setReadTimeout(5000);
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "zxing.org");
        connection.setRequestProperty("Connection", "close");
        try {
            connection.connect();
        }
        catch (IOException | IllegalArgumentException e) {
            log.info(e.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try (InputStream is = connection.getInputStream();){
            try {
                if (connection.getResponseCode() != 200) {
                    log.info("Unsuccessful return code: " + connection.getResponseCode());
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
                    return;
                }
                if ((long)connection.getHeaderFieldInt("Content-Length", 0) > 0x4000000L) {
                    log.info("Too large");
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
                    return;
                }
                log.info("Decoding " + imageURL);
                DecodeServlet.processStream((InputStream)is, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            finally {
                DecodeServlet.consumeRemainder((InputStream)is);
            }
        }
        catch (IOException ioe) {
            log.info(ioe.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        finally {
            connection.disconnect();
        }
    }

    private static void consumeRemainder(InputStream is) {
        try {
            while (is.read(REMAINDER_BUFFER) > 0) {
            }
        }
        catch (IOException | IndexOutOfBoundsException exception) {
            // empty catch block
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection parts;
        try {
            parts = request.getParts();
        }
        catch (IllegalStateException ise) {
            log.info("File upload was too large or invalid");
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        catch (IOException ioe) {
            log.info(ioe.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        Part fileUploadPart = null;
        for (Part part : parts) {
            if (part.getHeader("Content-Disposition") == null) continue;
            fileUploadPart = part;
            break;
        }
        if (fileUploadPart == null) {
            log.info("File upload was not multipart");
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
        } else {
            log.info("Decoding uploaded file " + fileUploadPart.getSubmittedFileName());
            try (InputStream is = fileUploadPart.getInputStream();){
                DecodeServlet.processStream((InputStream)is, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private static void processStream(InputStream is, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(is);
        }
        catch (CMMException | IOException | IllegalArgumentException ioe) {
            log.info(ioe.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        if (image == null) {
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        if (image.getHeight() <= 1 || image.getWidth() <= 1 || image.getHeight() * image.getWidth() > 0x4000000) {
            log.info("Dimensions out of bounds: " + image.getWidth() + 'x' + image.getHeight());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        DecodeServlet.processImage((BufferedImage)image, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private static void processImage(BufferedImage image, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean minimalOutput;
        ArrayList<Result> results;
        block35: {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
            results = new ArrayList<Result>(1);
            try {
                Result theResult;
                MultiFormatReader reader = new MultiFormatReader();
                ReaderException savedException = null;
                try {
                    GenericMultipleBarcodeReader multiReader = new GenericMultipleBarcodeReader((Reader)reader);
                    Result[] theResults = multiReader.decodeMultiple(bitmap, HINTS);
                    if (theResults != null) {
                        results.addAll(Arrays.asList(theResults));
                    }
                }
                catch (ReaderException re) {
                    savedException = re;
                }
                if (results.isEmpty()) {
                    try {
                        theResult = reader.decode(bitmap, HINTS_PURE);
                        if (theResult != null) {
                            results.add(theResult);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (results.isEmpty()) {
                    try {
                        theResult = reader.decode(bitmap, HINTS);
                        if (theResult != null) {
                            results.add(theResult);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (results.isEmpty()) {
                    try {
                        BinaryBitmap hybridBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                        Result theResult2 = reader.decode(hybridBitmap, HINTS);
                        if (theResult2 != null) {
                            results.add(theResult2);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (!results.isEmpty()) break block35;
                try {
                    throw savedException == null ? NotFoundException.getNotFoundInstance() : savedException;
                }
                catch (ChecksumException | FormatException e) {
                    log.info(e.toString());
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"format");
                }
                catch (ReaderException e) {
                    log.info(e.toString());
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"notfound");
                }
                return;
            }
            catch (RuntimeException re) {
                log.log(Level.WARNING, "Unexpected exception from library", re);
                throw new ServletException((Throwable)re);
            }
        }
        String fullParameter = request.getParameter("full");
        boolean bl = minimalOutput = fullParameter != null && !Boolean.parseBoolean(fullParameter);
        if (minimalOutput) {
            response.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);){
                for (Result result : results) {
                    out.write(result.getText());
                    ((Writer)out).write(10);
                }
            }
        } else {
            request.setAttribute("results", results);
            request.getRequestDispatcher("decoderesult.jspx").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static void errorResponse(HttpServletRequest request, HttpServletResponse response, String key) throws ServletException, IOException {
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        ResourceBundle bundle = ResourceBundle.getBundle("Strings", locale);
        String title = bundle.getString("response.error." + key + ".title");
        String text = bundle.getString("response.error." + key + ".text");
        request.setAttribute("title", (Object)title);
        request.setAttribute("text", (Object)text);
        request.getRequestDispatcher("response.jspx").forward((ServletRequest)request, (ServletResponse)response);
    }

    static {
        HINTS.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
        HINTS_PURE = new EnumMap(HINTS);
        HINTS_PURE.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
    }
}

