/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(value={"/w/decode"})
public final class DoSFilter
implements Filter {
    private static final Logger log = Logger.getLogger(DoSFilter.class.getName());
    private static final int MAX_ACCESSES_PER_IP_PER_TIME = 10;
    private static final int MAX_RECENT_ACCESS_MAP_SIZE = 100000;
    private final Map<String, AtomicInteger> numRecentAccesses = Collections.synchronizedMap(new /* Unavailable Anonymous Inner Class!! */);
    private final Set<String> bannedIPAddresses = Collections.synchronizedSet(new HashSet());
    private Timer timer;

    public void init(FilterConfig filterConfig) {
        this.timer = new Timer("DoSFilter reset timer");
        this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES));
        this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isBanned((HttpServletRequest)request)) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.sendError(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isBanned(HttpServletRequest request) {
        String remoteIPAddress = request.getHeader("x-forwarded-for");
        if (remoteIPAddress == null) {
            remoteIPAddress = request.getRemoteAddr();
        }
        if (remoteIPAddress == null || this.bannedIPAddresses.contains(remoteIPAddress)) {
            return true;
        }
        if (this.getCount(remoteIPAddress) > 10) {
            log.warning("Possible DoS attack from " + remoteIPAddress);
            this.bannedIPAddresses.add(remoteIPAddress);
            return true;
        }
        return false;
    }

    private int getCount(String remoteIPAddress) {
        AtomicInteger count = (AtomicInteger)this.numRecentAccesses.get(remoteIPAddress);
        if (count == null) {
            this.numRecentAccesses.put(remoteIPAddress, new AtomicInteger(1));
            return 1;
        }
        return count.incrementAndGet();
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    static /* synthetic */ Map access$000(DoSFilter x0) {
        return x0.numRecentAccesses;
    }

    static /* synthetic */ Set access$100(DoSFilter x0) {
        return x0.bannedIPAddresses;
    }
}

